/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.excel.convertor;

import com.feilong.excel.ExcelException;
import com.feilong.excel.definition.ExcelCell;
import com.feilong.lib.excel.convertor.AbstractChoiceConvertor;

public class LongConvertor
extends AbstractChoiceConvertor<Long> {
    @Override
    protected Long convertValue(int sheetNo, String cellIndex, ExcelCell excelCell, Object value) {
        if (value instanceof String) {
            String str = (String)value;
            if ((str = str.trim()).length() == 0) {
                if (excelCell.isMandatory()) {
                    throw new ExcelException(1, sheetNo, cellIndex, value, excelCell);
                }
                return null;
            }
            try {
                return Long.parseLong((String)value);
            }
            catch (NumberFormatException e) {
                throw new ExcelException(11, sheetNo, cellIndex, value, excelCell);
            }
        }
        if (value instanceof Double) {
            return Math.round((Double)value);
        }
        throw new ExcelException(11, sheetNo, cellIndex, value, excelCell);
    }

    @Override
    public String getDataTypeAbbr() {
        return "long";
    }

    @Override
    public Class<Long> supportClass() {
        return Long.class;
    }
}

