/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.excel.convertor;

import com.feilong.excel.ExcelException;
import com.feilong.excel.definition.ExcelCell;
import com.feilong.lib.excel.convertor.AbstractDataConvertor;

public class DoubleConvertor
extends AbstractDataConvertor<Double> {
    @Override
    protected Double handleConvert(Object value, int sheetNo, String cellIndex, ExcelCell excelCell) {
        if (value instanceof String) {
            String str = (String)value;
            if ((str = str.trim()).length() == 0) {
                if (excelCell.isMandatory()) {
                    throw new ExcelException(1, sheetNo, cellIndex, null, excelCell);
                }
                return null;
            }
            try {
                return new Double((String)value);
            }
            catch (NumberFormatException e) {
                throw new ExcelException(11, sheetNo, cellIndex, value, excelCell);
            }
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        throw new ExcelException(11, sheetNo, cellIndex, value, excelCell);
    }

    @Override
    public String getDataTypeAbbr() {
        return "double";
    }

    @Override
    public Class<Double> supportClass() {
        return Double.class;
    }
}

