/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.codec.binary;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class StringUtils {
    private static byte[] getBytes(String string, Charset charset) {
        if (string == null) {
            return null;
        }
        return string.getBytes(charset);
    }

    public static byte[] getBytesUnchecked(String string, String charsetName) {
        if (string == null) {
            return null;
        }
        try {
            return string.getBytes(charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw StringUtils.newIllegalStateException(charsetName, e);
        }
    }

    public static byte[] getBytesUtf8(String string) {
        return StringUtils.getBytes(string, StandardCharsets.UTF_8);
    }

    private static IllegalStateException newIllegalStateException(String charsetName, UnsupportedEncodingException e) {
        return new IllegalStateException(charsetName + ": " + e);
    }

    private static String newString(byte[] bytes, Charset charset) {
        return bytes == null ? null : new String(bytes, charset);
    }

    public static String newStringUsAscii(byte[] bytes) {
        return StringUtils.newString(bytes, StandardCharsets.US_ASCII);
    }

    public static String newStringUtf8(byte[] bytes) {
        return StringUtils.newString(bytes, StandardCharsets.UTF_8);
    }
}

