/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.beanutils;

import com.feilong.lib.beanutils.BeanIntrospector;
import com.feilong.lib.beanutils.IntrospectionContext;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FluentPropertyBeanIntrospector
implements BeanIntrospector {
    public static final String DEFAULT_WRITE_METHOD_PREFIX = "set";
    private static final Logger LOGGER = LoggerFactory.getLogger(FluentPropertyBeanIntrospector.class);
    private final String writeMethodPrefix;

    public FluentPropertyBeanIntrospector(String writePrefix) {
        if (writePrefix == null) {
            throw new IllegalArgumentException("Prefix for write methods must not be null!");
        }
        this.writeMethodPrefix = writePrefix;
    }

    public FluentPropertyBeanIntrospector() {
        this(DEFAULT_WRITE_METHOD_PREFIX);
    }

    public String getWriteMethodPrefix() {
        return this.writeMethodPrefix;
    }

    @Override
    public void introspect(IntrospectionContext icontext) throws IntrospectionException {
        for (Method m : icontext.getTargetClass().getMethods()) {
            if (!m.getName().startsWith(this.getWriteMethodPrefix())) continue;
            String propertyName = this.propertyName(m);
            PropertyDescriptor pd = icontext.getPropertyDescriptor(propertyName);
            try {
                if (pd == null) {
                    icontext.addPropertyDescriptor(this.createFluentPropertyDescritor(m, propertyName));
                    continue;
                }
                if (pd.getWriteMethod() != null) continue;
                pd.setWriteMethod(m);
            }
            catch (IntrospectionException e) {
                LOGGER.info("Error when creating PropertyDescriptor for " + m + "! Ignoring this property.");
                LOGGER.debug("Exception is:", (Throwable)e);
            }
        }
    }

    private String propertyName(Method m) {
        String methodName = m.getName().substring(this.getWriteMethodPrefix().length());
        return methodName.length() > 1 ? Introspector.decapitalize(methodName) : methodName.toLowerCase(Locale.ENGLISH);
    }

    private PropertyDescriptor createFluentPropertyDescritor(Method m, String propertyName) throws IntrospectionException {
        return new PropertyDescriptor(this.propertyName(m), null, m);
    }
}

