/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.json.builder;

import com.feilong.core.Validator;
import com.feilong.json.JsonToJavaConfig;
import com.feilong.json.builder.ArrayExcludePropertyNamesPropertyFilter;
import com.feilong.lib.json.JsonConfig;
import com.feilong.lib.json.util.JavaIdentifierTransformer;
import com.feilong.lib.json.util.PropertyFilter;
import java.util.Map;

public final class JsonToJavaConfigBuilder {
    private JsonToJavaConfigBuilder() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static JsonConfig build(Class<?> rootClass, JsonToJavaConfig jsonToJavaConfig) {
        PropertyFilter propertyFilter;
        Map<String, Class<?>> classMap;
        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.setRootClass(rootClass);
        JavaIdentifierTransformer javaIdentifierTransformer = jsonToJavaConfig.getJavaIdentifierTransformer();
        if (Validator.isNotNullOrEmpty(javaIdentifierTransformer)) {
            jsonConfig.setJavaIdentifierTransformer(javaIdentifierTransformer);
        }
        if (Validator.isNotNullOrEmpty(classMap = jsonToJavaConfig.getClassMap())) {
            jsonConfig.setClassMap(classMap);
        }
        if (null != (propertyFilter = JsonToJavaConfigBuilder.build(jsonToJavaConfig))) {
            jsonConfig.setJavaPropertyFilter(propertyFilter);
        }
        return jsonConfig;
    }

    private static PropertyFilter build(JsonToJavaConfig jsonToJavaConfig) {
        String[] excludes = jsonToJavaConfig.getExcludes();
        if (Validator.isNotNullOrEmpty(excludes)) {
            return new ArrayExcludePropertyNamesPropertyFilter(excludes);
        }
        return null;
    }
}

