/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.excel.writer;

import com.feilong.excel.writer.CellCoper;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class SheetCopyer {
    private SheetCopyer() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    static void copy(Sheet sheet, Sheet newSheet) {
        int maxCol = 0;
        for (int row = 0; row <= sheet.getLastRowNum(); ++row) {
            Row oldRow = sheet.getRow(row);
            if (oldRow == null) continue;
            Row newRow = newSheet.getRow(row);
            if (newRow == null) {
                newRow = newSheet.createRow(row);
            }
            if (oldRow.getHeight() >= 0) {
                newRow.setHeight(oldRow.getHeight());
            }
            maxCol = maxCol >= oldRow.getLastCellNum() - 1 ? maxCol : oldRow.getLastCellNum() - 1;
            for (int col = 0; col < oldRow.getLastCellNum(); ++col) {
                Cell oldCell = oldRow.getCell(col);
                if (oldCell == null) continue;
                Cell newCell = newRow.getCell(col);
                if (newCell == null) {
                    newCell = newRow.createCell(col);
                }
                CellCoper.copy(oldCell, newCell);
            }
        }
        for (int col = 0; col <= maxCol; ++col) {
            if (sheet.getColumnWidth(col) < 0) continue;
            newSheet.setColumnWidth(col, sheet.getColumnWidth(col));
        }
        for (int i = 0; i < sheet.getNumMergedRegions(); ++i) {
            CellRangeAddress cellRangeAddress = sheet.getMergedRegion(i);
            newSheet.addMergedRegion(cellRangeAddress);
        }
    }
}

