/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.excel.writer;

import com.feilong.core.Validator;
import com.feilong.core.lang.ObjectUtil;
import com.feilong.excel.definition.ExcelBlock;
import com.feilong.excel.definition.ExcelCell;
import com.feilong.excel.definition.ExcelCellConditionStyle;
import com.feilong.excel.writer.BlockCopyer;
import com.feilong.excel.writer.BlockStyleSetter;
import com.feilong.excel.writer.CellStyleSetter;
import com.feilong.excel.writer.CellValueSetter;
import com.feilong.excel.writer.FormulaEvaluatorUtil;
import com.feilong.lib.excel.ognl.OgnlStack;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

class ColumnWriter {
    private ColumnWriter() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    static void write(Sheet sheet, ExcelBlock excelBlock, OgnlStack ognlStack, int rowOffset, int colOffset, List<CellRangeAddress> mergedRegions, Map<String, CellStyle> styleMap) {
        if (rowOffset > 0 || colOffset > 0) {
            int startRow = excelBlock.getStartRow();
            int startCol = excelBlock.getStartCol();
            int endRow = excelBlock.getEndRow();
            int endCol = excelBlock.getEndCol();
            BlockCopyer.copy(sheet, startRow, startCol, endRow, endCol, rowOffset, colOffset, mergedRegions);
        }
        if (Validator.isNotNullOrEmpty(styleMap)) {
            for (ExcelCellConditionStyle style : excelBlock.getStyles()) {
                Object obj = ognlStack.getValue(style.getCondition());
                if (obj == null || !(obj instanceof Boolean) || !((Boolean)obj).booleanValue()) continue;
                int startRowIndex = style.getStartRow() + rowOffset;
                int endRowIndex = style.getEndRow() + rowOffset;
                int startColumnIndex = style.getStartCol() + colOffset;
                int endColumnIndex = style.getEndCol() + colOffset;
                String cellIndex = style.getCellIndex();
                BlockStyleSetter.set(sheet, startRowIndex, endRowIndex, startColumnIndex, endColumnIndex, cellIndex, styleMap);
            }
        }
        for (ExcelCell excelCell : excelBlock.getCells()) {
            String dataName = ColumnWriter.buildDataName(rowOffset, colOffset, excelCell);
            int row = excelCell.getRow();
            int col = excelCell.getCol();
            CellValueSetter.set(sheet, row + rowOffset, col + colOffset, dataName, ognlStack);
            if (!Validator.isNotNullOrEmpty(styleMap)) continue;
            for (ExcelCellConditionStyle excelCellConditionStyle : excelCell.getStyles()) {
                Object obj = ognlStack.getValue(excelCellConditionStyle.getCondition());
                if (obj == null || !(obj instanceof Boolean) || !((Boolean)obj).booleanValue()) continue;
                CellStyleSetter.set(sheet, row + rowOffset, col + colOffset, styleMap.get(excelCellConditionStyle.getCellIndex()));
            }
        }
    }

    private static String buildDataName(int rowOffset, int colOffset, ExcelCell excelCell) {
        String dataName = ObjectUtil.defaultIfNullOrEmpty(excelCell.getDataExpr(), excelCell.getDataName());
        if (dataName.startsWith("=")) {
            return FormulaEvaluatorUtil.offsetFormula(dataName, rowOffset, colOffset);
        }
        return dataName;
    }
}

