/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.excel.writer;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

class CellStyleSetter {
    private CellStyleSetter() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    static void set(Sheet sheet, int rowIndex, int cellIndex, CellStyle cellStyle) {
        CellStyle currentCellStyle;
        Cell cell;
        if (cellStyle == null) {
            return;
        }
        Row row = sheet.getRow(rowIndex);
        if (row == null) {
            row = sheet.createRow(rowIndex);
        }
        if ((cell = row.getCell(cellIndex)) == null) {
            cell = row.createCell(cellIndex);
        }
        if ((currentCellStyle = cell.getCellStyle()) == null || cell.getCellType() != CellType.NUMERIC || !DateUtil.isCellDateFormatted((Cell)cell) || DateUtil.isADateFormat((int)cellStyle.getDataFormat(), (String)cellStyle.getDataFormatString())) {
            cell.setCellStyle(cellStyle);
        } else {
            CellStyle newCellStyle = sheet.getWorkbook().createCellStyle();
            newCellStyle.cloneStyleFrom(cellStyle);
            newCellStyle.setDataFormat(currentCellStyle.getDataFormat());
            cell.setCellStyle(newCellStyle);
        }
    }
}

