/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.excel.definition;

import com.feilong.core.DefaultRuntimeException;
import com.feilong.excel.definition.ExcelCell;
import com.feilong.excel.definition.ExcelCellConditionStyle;
import com.feilong.excel.definition.LoopBreakCondition;
import com.feilong.excel.util.CellReferenceUtil;
import java.util.ArrayList;
import java.util.List;

public class ExcelBlock
implements Comparable<ExcelBlock> {
    public static final String LOOP_DIRECTION_HORIZONAL = "horizontal";
    public static final String LOOP_DIRECTION_VERTICAL = "vertical";
    private int startRow = 0;
    private int startCol = 0;
    private int endRow = 0;
    private int endCol = 0;
    private String dataName;
    private boolean isLoop = false;
    private Class<?> loopClass;
    private String direction = "horizontal";
    private LoopBreakCondition breakCondition;
    private List<ExcelCell> cells = new ArrayList<ExcelCell>();
    private List<ExcelCellConditionStyle> styles = new ArrayList<ExcelCellConditionStyle>();
    private boolean isChildBlock = false;
    private ExcelBlock childBlock;

    public void setStartCellIndex(String startCellIndex) {
        int[] value = CellReferenceUtil.getCellPosition(startCellIndex);
        this.startRow = value[0];
        this.startCol = value[1];
    }

    public String getEndCellIndex() {
        return CellReferenceUtil.getCellRef(this.endRow, this.endCol);
    }

    public void setEndCellIndex(String endCellIndex) {
        int[] value = CellReferenceUtil.getCellPosition(endCellIndex);
        this.endRow = value[0];
        this.endCol = value[1];
    }

    public int getStartRow() {
        return this.startRow;
    }

    public void setStartRow(int startRow) {
        this.startRow = startRow;
    }

    public int getStartCol() {
        return this.startCol;
    }

    public void setStartCol(int startCol) {
        this.startCol = startCol;
    }

    public int getEndRow() {
        return this.endRow;
    }

    public void setEndRow(int endRow) {
        this.endRow = endRow;
    }

    public int getEndCol() {
        return this.endCol;
    }

    public void setEndCol(int endCol) {
        this.endCol = endCol;
    }

    public String getDataName() {
        return this.dataName;
    }

    public void setDataName(String dataName) {
        this.dataName = dataName;
    }

    public boolean isLoop() {
        return this.isLoop;
    }

    public void setLoop(boolean isLoop) {
        this.isLoop = isLoop;
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public Class<?> getLoopClass() {
        return this.loopClass;
    }

    public void setLoopClass(Class<?> loopClass) {
        this.loopClass = loopClass;
    }

    public List<ExcelCell> getCells() {
        return this.cells;
    }

    public void setCells(List<ExcelCell> cells) {
        this.cells = cells;
    }

    public void addCell(ExcelCell cell) {
        this.cells.add(cell);
    }

    public ExcelBlock getChildBlock() {
        return this.childBlock;
    }

    public void setChildBlock(ExcelBlock childBlock) {
        if (childBlock == null) {
            this.childBlock = null;
            return;
        }
        childBlock.setLoop(true);
        childBlock.setEndCellIndex(this.getEndCellIndex());
        this.childBlock = childBlock;
    }

    public LoopBreakCondition getBreakCondition() {
        return this.breakCondition;
    }

    public void setBreakCondition(LoopBreakCondition breakCondition) {
        this.breakCondition = breakCondition;
    }

    public boolean isChild() {
        return this.isChildBlock;
    }

    public void setChild(boolean isChildBlock) {
        this.isChildBlock = isChildBlock;
    }

    public void setLoopClassByClassName(String className) {
        try {
            this.setLoopClass(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            throw new DefaultRuntimeException(className + " is not found.");
        }
    }

    public String toString() {
        return "ExcelBlock[" + CellReferenceUtil.getCellRef(this.startRow, this.startCol) + ":" + this.getEndCellIndex() + "]";
    }

    @Override
    public int compareTo(ExcelBlock excelBlock) {
        int result = excelBlock.getStartRow() - this.getStartRow();
        if (result == 0) {
            return excelBlock.getStartCol() - this.getStartCol();
        }
        return result;
    }

    public List<ExcelCellConditionStyle> getStyles() {
        return this.styles;
    }

    public void setStyles(List<ExcelCellConditionStyle> styles) {
        this.styles = styles;
    }
}

