/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.excel;

import com.feilong.core.DefaultRuntimeException;
import com.feilong.excel.AbstractExcelConfig;
import com.feilong.excel.ExcelDefinition;
import com.feilong.excel.ExcelWriter;
import com.feilong.excel.util.WorkbookUtil;
import com.feilong.excel.writer.WorkbookWriter;
import com.feilong.io.InputStreamUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExcelWriter
extends AbstractExcelConfig
implements ExcelWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExcelWriter.class);
    private byte[] bufferedTemplate;

    public DefaultExcelWriter() {
    }

    public DefaultExcelWriter(ExcelDefinition excelDefinition) {
        this.excelDefinition = excelDefinition;
    }

    @Override
    public void write(String template, OutputStream outputStream, Map<String, Object> data) {
        this.write(InputStreamUtil.getInputStream(template), outputStream, data);
    }

    @Override
    public void write(OutputStream outputStream, Map<String, Object> data) {
        if (this.bufferedTemplate == null) {
            throw new IllegalArgumentException("bufferedTemplate is null");
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.bufferedTemplate);
        this.write(inputStream, outputStream, data);
    }

    private void write(InputStream inputStream, OutputStream outputStream, Map<String, Object> data) {
        Workbook workbook = WorkbookUtil.create(inputStream);
        WorkbookWriter.write(workbook, outputStream, this.excelDefinition, data);
    }

    @Override
    public void writePerSheet(String template, OutputStream os, List<Map<String, Object>> beansList) {
        this.writePerSheet(InputStreamUtil.getInputStream(template), os, beansList);
    }

    @Override
    public void writePerSheet(OutputStream outputStream, List<Map<String, Object>> beansList) {
        if (this.bufferedTemplate == null) {
            throw new IllegalArgumentException("bufferedTemplate is null");
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.bufferedTemplate);
        this.writePerSheet(inputStream, outputStream, beansList);
    }

    @Override
    public void writePerSheet(InputStream inputStream, OutputStream outputStream, List<Map<String, Object>> beansList) {
        try (Workbook workbook = WorkbookUtil.create(inputStream);){
            WorkbookWriter.writePerSheet(workbook, outputStream, this.excelDefinition, beansList);
        }
        catch (Exception e) {
            throw new DefaultRuntimeException(e);
        }
    }

    public void initBufferedTemplate(InputStream inputStream) {
        try {
            byte[] buf = new byte[1024];
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int b = inputStream.read(buf);
            while (b != -1) {
                bos.write(buf, 0, b);
                b = inputStream.read(buf);
            }
            this.bufferedTemplate = bos.toByteArray();
        }
        catch (IOException e) {
            LOGGER.error("Init Write Template Error", (Throwable)e);
        }
    }
}

