/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.excel;

import com.feilong.lib.excel.convertor.BigDecimalConvertor;
import com.feilong.lib.excel.convertor.BooleanConvertor;
import com.feilong.lib.excel.convertor.DataConvertor;
import com.feilong.lib.excel.convertor.DateConvertor;
import com.feilong.lib.excel.convertor.DoubleConvertor;
import com.feilong.lib.excel.convertor.IntegerConvertor;
import com.feilong.lib.excel.convertor.LongConvertor;
import com.feilong.lib.excel.convertor.StringConvertor;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class DataConvertorConfig
implements Serializable {
    private static final long serialVersionUID = -6172555487692156540L;
    private final Map<String, Class<?>> supportsMap = new HashMap();
    private final Map<Class<?>, DataConvertor<?>> convertorMap = new HashMap();
    private static DataConvertorConfig instance;

    private DataConvertorConfig() {
        this.registerDataConvertor(new StringConvertor());
        this.registerDataConvertor(new IntegerConvertor());
        this.registerDataConvertor(new LongConvertor());
        this.registerDataConvertor(new DoubleConvertor());
        this.registerDataConvertor(new BigDecimalConvertor());
        this.registerDataConvertor(new DateConvertor());
        this.registerDataConvertor(new BooleanConvertor());
    }

    public void registerDataConvertor(DataConvertor<?> dataConvertor) {
        this.supportsMap.put(dataConvertor.getDataTypeAbbr(), dataConvertor.supportClass());
        this.convertorMap.put(dataConvertor.supportClass(), dataConvertor);
    }

    public <T> DataConvertor<T> getConvertor(Class<T> clazz) {
        return this.convertorMap.get(clazz);
    }

    public Class<?> getSupportedClass(String name) {
        return this.supportsMap.get(name);
    }

    public static DataConvertorConfig getInstance() {
        if (instance == null) {
            instance = new DataConvertorConfig();
        }
        return instance;
    }
}

