/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.csv.handler;

import com.feilong.core.Validate;
import com.feilong.core.Validator;
import com.feilong.core.lang.reflect.FieldUtil;
import com.feilong.core.util.CollectionsUtil;
import com.feilong.core.util.SortUtil;
import com.feilong.csv.entity.BeanCsvConfig;
import com.feilong.csv.entity.CsvColumnEntity;
import com.feilong.csv.handler.CsvColumnEntityBuilder;
import java.lang.reflect.Field;
import java.util.List;

public class CsvColumnEntityListBuilder {
    private CsvColumnEntityListBuilder() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static <T> List<CsvColumnEntity> build(BeanCsvConfig<T> beanCsvConfig) {
        Validate.notNull(beanCsvConfig, "beanCsvConfig can't be null!", new Object[0]);
        List<CsvColumnEntity> csvColumnEntityList = CsvColumnEntityListBuilder.buildCsvColumnEntityList(beanCsvConfig);
        if (Validator.isNotNullOrEmpty(beanCsvConfig.getIncludePropertyNames())) {
            csvColumnEntityList = CollectionsUtil.select(csvColumnEntityList, "name", beanCsvConfig.getIncludePropertyNames());
        }
        return SortUtil.sortListByPropertyNamesValue(csvColumnEntityList, "order", "propertyName");
    }

    private static <T> List<CsvColumnEntity> buildCsvColumnEntityList(BeanCsvConfig<T> beanCsvConfig) {
        List<Field> fieldsList = FieldUtil.getAllFieldList(beanCsvConfig.getBeanClass(), beanCsvConfig.getExcludePropertyNames());
        List<CsvColumnEntity> list = CollectionsUtil.newArrayList();
        for (Field field : fieldsList) {
            list.add(CsvColumnEntityBuilder.buildCsvColumnEntity(field));
        }
        return list;
    }
}

