/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.core.util;

import com.feilong.core.Validate;
import com.feilong.core.Validator;
import com.feilong.core.bean.ConvertUtil;
import com.feilong.core.bean.PropertyUtil;
import com.feilong.core.bean.PropertyValueObtainer;
import com.feilong.core.util.MapUtil;
import com.feilong.core.util.closure.BeanPropertyValueChangeClosure;
import com.feilong.core.util.predicate.BeanPredicateUtil;
import com.feilong.core.util.transformer.BeanTransformer;
import com.feilong.lib.collection4.CollectionUtils;
import com.feilong.lib.collection4.IterableUtils;
import com.feilong.lib.collection4.ListUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.Transformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CollectionsUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectionsUtil.class);

    private CollectionsUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static <O> void forEach(Iterable<O> beanIterable, String propertyName, Object propertyValue) {
        if (Validator.isNotNullOrEmpty(beanIterable)) {
            IterableUtils.forEach(beanIterable, new BeanPropertyValueChangeClosure(propertyName, propertyValue));
        }
    }

    public static <O> boolean addAllIgnoreNull(Collection<O> objectCollection, Iterable<? extends O> iterable) {
        Validate.notNull(objectCollection, "objectCollection can't be null!", new Object[0]);
        return null != iterable && CollectionUtils.addAll(objectCollection, iterable);
    }

    public static <T> boolean addIgnoreNullOrEmpty(Collection<T> objectCollection, T element) {
        Validate.notNull(objectCollection, "objectCollection can't be null!", new Object[0]);
        return Validator.isNotNullOrEmpty(element) && objectCollection.add(element);
    }

    public static <O, V> int indexOf(List<O> list, String propertyName, V propertyValue) {
        return ListUtils.indexOf(list, BeanPredicateUtil.equalPredicate(propertyName, propertyValue));
    }

    public static <O> List<O> removeAll(Collection<O> objectCollection, Collection<O> removeCollection) {
        Validate.notNull(objectCollection, "objectCollection can't be null!", new Object[0]);
        Validate.notNull(removeCollection, "removeCollection can't be null!", new Object[0]);
        return ListUtils.removeAll(objectCollection, removeCollection);
    }

    public static <O> List<O> removeAllNull(Collection<O> objectCollection) {
        Validate.notNull(objectCollection, "objectCollection can't be null!", new Object[0]);
        return CollectionsUtil.remove(objectCollection, ConvertUtil.toArray(new Object[]{null}));
    }

    @SafeVarargs
    public static <O> List<O> remove(Collection<O> objectCollection, O ... removeElements) {
        return CollectionsUtil.removeAll(objectCollection, ConvertUtil.toList(removeElements));
    }

    public static <O> List<O> removeDuplicate(Collection<O> objectCollection) {
        return Validator.isNullOrEmpty(objectCollection) ? Collections.emptyList() : ConvertUtil.toList(new LinkedHashSet<O>(objectCollection));
    }

    public static <O> List<O> removeDuplicate(Collection<O> objectCollection, String propertyName) {
        if (Validator.isNullOrEmpty(propertyName)) {
            return CollectionsUtil.removeDuplicate(objectCollection);
        }
        if (Validator.isNullOrEmpty(objectCollection)) {
            return Collections.emptyList();
        }
        Map map = CollectionsUtil.groupOne(objectCollection, propertyName);
        return ConvertUtil.toList(map.values());
    }

    public static <O> List<O> removeDuplicate(Collection<O> objectCollection, String ... propertyNames) {
        if (Validator.isNullOrEmpty(propertyNames)) {
            return CollectionsUtil.removeDuplicate(objectCollection);
        }
        if (Validator.isNullOrEmpty(objectCollection)) {
            return Collections.emptyList();
        }
        List<Map<String, Object>> mapList = CollectionsUtil.newArrayList();
        ArrayList<O> returnList = new ArrayList<O>(IterableUtils.size(objectCollection));
        for (O o : objectCollection) {
            Map<String, Object> propertyNameAndValueMap = PropertyUtil.describe(o, propertyNames);
            boolean isNotExist = !CollectionsUtil.isExist(mapList, propertyNameAndValueMap, propertyNames);
            if (!isNotExist) continue;
            returnList.add(o);
            mapList.add(propertyNameAndValueMap);
        }
        return returnList;
    }

    private static boolean isExist(List<Map<String, Object>> mapList, Map<String, Object> propertyNameAndValueMap, String ... keys) {
        for (Map<String, Object> map : mapList) {
            if (!CollectionsUtil.eqauls(map, propertyNameAndValueMap, keys)) continue;
            return true;
        }
        return false;
    }

    private static boolean eqauls(Map<String, Object> map, Map<String, Object> propertyNameAndValueMap, String ... keys) {
        for (String propertyName : keys) {
            if (Objects.equals(map.get(propertyName), propertyNameAndValueMap.get(propertyName))) continue;
            return false;
        }
        return true;
    }

    public static <T, O> List<T> getPropertyValueList(Iterable<O> beanIterable, String propertyName) {
        if (Validator.isNullOrEmpty(beanIterable)) {
            return Collections.emptyList();
        }
        return PropertyValueObtainer.getPropertyValueCollection(beanIterable, propertyName, new ArrayList(IterableUtils.size(beanIterable)));
    }

    public static <T, O> Set<T> getPropertyValueSet(Iterable<O> beanIterable, String propertyName) {
        if (Validator.isNullOrEmpty(beanIterable)) {
            return Collections.emptySet();
        }
        return PropertyValueObtainer.getPropertyValueCollection(beanIterable, propertyName, new LinkedHashSet(IterableUtils.size(beanIterable)));
    }

    public static <K, V, O> Map<K, V> getPropertyValueMap(Iterable<O> beanIterable, String keyPropertyName, String valuePropertyName) {
        if (Validator.isNullOrEmpty(beanIterable)) {
            return Collections.emptyMap();
        }
        Validate.notBlank(keyPropertyName, "keyPropertyName can't be null/empty!", new Object[0]);
        Validate.notBlank(valuePropertyName, "valuePropertyName can't be null/empty!", new Object[0]);
        Map map = MapUtil.newLinkedHashMap(IterableUtils.size(beanIterable));
        for (O bean : beanIterable) {
            map.put(PropertyUtil.getProperty(bean, keyPropertyName), PropertyUtil.getProperty(bean, valuePropertyName));
        }
        return map;
    }

    public static <O, V> O find(Iterable<O> beanIterable, String propertyName, V propertyValue) {
        return null == beanIterable ? null : (O)CollectionsUtil.find(beanIterable, BeanPredicateUtil.equalPredicate(propertyName, propertyValue));
    }

    public static <O> O find(Iterable<O> beanIterable, Map<String, ?> propertyNameAndPropertyValueMap) {
        return null == beanIterable ? null : (O)CollectionsUtil.find(beanIterable, BeanPredicateUtil.equalPredicate(propertyNameAndPropertyValueMap));
    }

    public static <O> O find(Iterable<O> iterable, Predicate<O> predicate) {
        return IterableUtils.find(iterable, predicate);
    }

    @SafeVarargs
    public static <O, V> List<O> select(Iterable<O> beanIterable, String propertyName, V ... propertyValues) {
        return Validator.isNullOrEmpty(beanIterable) ? Collections.emptyList() : CollectionsUtil.select(beanIterable, BeanPredicateUtil.containsPredicate(propertyName, propertyValues));
    }

    public static <O, V> List<O> select(Iterable<O> beanIterable, String propertyName, Collection<V> propertyValueList) {
        return Validator.isNullOrEmpty(beanIterable) ? Collections.emptyList() : CollectionsUtil.select(beanIterable, BeanPredicateUtil.containsPredicate(propertyName, propertyValueList));
    }

    public static <O> List<O> select(Iterable<O> beanIterable, Predicate<O> predicate) {
        return Validator.isNullOrEmpty(beanIterable) ? Collections.emptyList() : (List)CollectionUtils.select(beanIterable, predicate);
    }

    @SafeVarargs
    public static <O, V> List<O> selectRejected(Iterable<O> beanIterable, String propertyName, V ... propertyValues) {
        return Validator.isNullOrEmpty(beanIterable) ? Collections.emptyList() : CollectionsUtil.selectRejected(beanIterable, BeanPredicateUtil.containsPredicate(propertyName, propertyValues));
    }

    public static <O, V> List<O> selectRejected(Iterable<O> beanIterable, String propertyName, Collection<V> propertyValueList) {
        return Validator.isNullOrEmpty(beanIterable) ? Collections.emptyList() : CollectionsUtil.selectRejected(beanIterable, BeanPredicateUtil.containsPredicate(propertyName, propertyValueList));
    }

    public static <O> List<O> selectRejected(Iterable<O> beanIterable, Predicate<O> predicate) {
        return Validator.isNullOrEmpty(beanIterable) ? Collections.emptyList() : (List)CollectionUtils.selectRejected(beanIterable, predicate);
    }

    public static <O, T> List<T> collect(Iterable<O> inputIterable, Transformer<? super O, ? extends T> transformer) {
        return null == inputIterable ? null : (List)CollectionUtils.collect(inputIterable, transformer);
    }

    public static <O, I> List<O> collect(Iterable<I> inputBeanIterable, Class<O> outputListBeanType, String ... includePropertyNames) {
        Validate.notNull(outputListBeanType, "outListBeanType can't be null!", new Object[0]);
        return CollectionsUtil.collect(inputBeanIterable, new BeanTransformer(outputListBeanType, includePropertyNames));
    }

    public static <O, T> List<T> collect(Iterator<O> inputIterator, Transformer<? super O, ? extends T> transformer) {
        return null == inputIterator ? null : (List)CollectionUtils.collect(inputIterator, transformer);
    }

    public static <T, O> Map<T, List<O>> group(Iterable<O> beanIterable, String propertyName) {
        return CollectionsUtil.group(beanIterable, propertyName, null);
    }

    public static <T, O> Map<T, List<O>> group(Iterable<O> beanIterable, final String propertyName, Predicate<O> includePredicate) {
        if (Validator.isNullOrEmpty(beanIterable)) {
            return Collections.emptyMap();
        }
        Validate.notBlank(propertyName, "propertyName can't be null/empty!", new Object[0]);
        return CollectionsUtil.group(beanIterable, includePredicate, new Transformer<O, T>(){

            @Override
            public T transform(O input) {
                return PropertyUtil.getProperty(input, propertyName);
            }
        });
    }

    public static <T, O> Map<T, List<O>> group(Iterable<O> beanIterable, Transformer<O, T> keyTransformer) {
        return CollectionsUtil.group(beanIterable, null, keyTransformer);
    }

    public static <T, O> Map<T, List<O>> group(Iterable<O> beanIterable, Predicate<O> includePredicate, Transformer<O, T> keyTransformer) {
        if (Validator.isNullOrEmpty(beanIterable)) {
            return Collections.emptyMap();
        }
        Validate.notNull(keyTransformer, "keyTransformer can't be null!", new Object[0]);
        Map map = MapUtil.newLinkedHashMap(IterableUtils.size(beanIterable));
        for (O obj : beanIterable) {
            if (null != includePredicate && !includePredicate.evaluate(obj)) continue;
            MapUtil.putMultiValue(map, keyTransformer.transform(obj), obj);
        }
        return map;
    }

    public static <T, O> Map<T, O> groupOne(Iterable<O> beanIterable, String propertyName) {
        if (Validator.isNullOrEmpty(beanIterable)) {
            return Collections.emptyMap();
        }
        Validate.notBlank(propertyName, "propertyName can't be null/empty!", new Object[0]);
        Map map = MapUtil.newLinkedHashMap(IterableUtils.size(beanIterable));
        for (O o : beanIterable) {
            Object key = PropertyUtil.getProperty(o, propertyName);
            if (!map.containsKey(key)) {
                map.put(key, o);
                continue;
            }
            if (!LOGGER.isTraceEnabled()) continue;
            LOGGER.trace("map:[{}] already has the key:[{}],ignore!", map.keySet(), key);
        }
        return map;
    }

    public static <E> List<E> newArrayList() {
        return new ArrayList();
    }

    public static <E> List<E> newLinkedList() {
        return new LinkedList();
    }

    public static <E> List<E> newCopyOnWriteArrayList() {
        return new CopyOnWriteArrayList();
    }

    public static <E> Set<E> newHashSet() {
        return new HashSet();
    }

    public static <E> Set<E> newLinkedHashSet() {
        return new LinkedHashSet();
    }
}

