/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.core.text;

import com.feilong.core.Validate;
import com.feilong.core.lang.ObjectUtil;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NumberFormatUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(NumberFormatUtil.class);

    private NumberFormatUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static String format(Number value, String numberPattern, RoundingMode roundingMode) {
        Validate.notNull(value, "value can't be null!", new Object[0]);
        Validate.notBlank(numberPattern, "numberPattern can't be null!", new Object[0]);
        DecimalFormat decimalFormat = new DecimalFormat(numberPattern);
        decimalFormat.setRoundingMode(ObjectUtil.defaultIfNull(roundingMode, RoundingMode.HALF_UP));
        String result = decimalFormat.format(value);
        if (LOGGER.isTraceEnabled()) {
            String message = "input:[{}],with:[{}]=[{}],localizedPattern:[{}]";
            LOGGER.trace(message, new Object[]{value, numberPattern, result, decimalFormat.toLocalizedPattern()});
        }
        return result;
    }
}

