/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.core.lang.thread;

import com.feilong.core.Validate;
import com.feilong.core.bean.ConvertUtil;
import com.feilong.core.lang.NumberUtil;
import com.feilong.core.lang.thread.PartitionEachSizeBuilder;
import com.feilong.core.lang.thread.PartitionThreadConfig;
import java.math.RoundingMode;

public class PartitionEachSizeThreadConfigBuilder
implements PartitionEachSizeBuilder {
    private PartitionThreadConfig partitionThreadConfig;

    public PartitionEachSizeThreadConfigBuilder() {
    }

    public PartitionEachSizeThreadConfigBuilder(PartitionThreadConfig partitionThreadConfig) {
        this.partitionThreadConfig = partitionThreadConfig;
    }

    @Override
    public int build(int totalSize) {
        Validate.isTrue(totalSize > 0, "totalSize must >0,totalSize:%s", totalSize);
        Validate.notNull(this.partitionThreadConfig, "partitionConfig can't be null!", new Object[0]);
        int maxThreadCount = this.partitionThreadConfig.getMaxThreadCount();
        int minPerThreadHandlerCount = this.partitionThreadConfig.getMinPerThreadHandlerCount();
        Validate.isTrue(maxThreadCount > 0, "maxThreadCount must >0,totalSize:%s", maxThreadCount);
        Validate.isTrue(minPerThreadHandlerCount > 0, "minPerThreadHandlerCount must >0,totalSize:%s", minPerThreadHandlerCount);
        if (totalSize <= minPerThreadHandlerCount) {
            return totalSize;
        }
        int threadCount = ConvertUtil.toInteger(NumberUtil.getDivideValue(totalSize, minPerThreadHandlerCount, 0, RoundingMode.UP));
        if (threadCount >= maxThreadCount) {
            return ConvertUtil.toInteger(NumberUtil.getDivideValue(totalSize, maxThreadCount, 0, RoundingMode.UP));
        }
        return threadCount;
    }

    public void setPartitionThreadConfig(PartitionThreadConfig partitionThreadConfig) {
        this.partitionThreadConfig = partitionThreadConfig;
    }
}

