/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.core.lang;

import com.feilong.core.Validate;
import com.feilong.core.bean.PropertyUtil;
import com.feilong.lib.lang3.StringUtils;
import com.feilong.tools.slf4j.Slf4jUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EnumUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnumUtil.class);

    private EnumUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static <E extends Enum<?>, T> E getEnumByPropertyValueIgnoreCase(Class<E> enumClass, String propertyName, T specifiedValue) {
        return EnumUtil.getEnumByPropertyValue(enumClass, propertyName, specifiedValue, true);
    }

    public static <E extends Enum<?>, T> E getEnumByPropertyValue(Class<E> enumClass, String propertyName, T specifiedValue) {
        return EnumUtil.getEnumByPropertyValue(enumClass, propertyName, specifiedValue, false);
    }

    private static <E extends Enum<?>, T> E getEnumByPropertyValue(Class<E> enumClass, String propertyName, T specifiedValue, boolean ignoreCase) {
        Validate.notNull(enumClass, "enumClass can't be null!", new Object[0]);
        Validate.notBlank(propertyName, "propertyName can't be null/empty!", new Object[0]);
        Enum[] enumConstants = (Enum[])enumClass.getEnumConstants();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("enumClass:[{}],enumConstants:[{}]", (Object)enumClass.getCanonicalName(), (Object)enumConstants);
        }
        for (Enum e : enumConstants) {
            Object propertyValue = PropertyUtil.getProperty(e, propertyName);
            if (!EnumUtil.isEquals(propertyValue, specifiedValue, ignoreCase)) continue;
            return (E)e;
        }
        if (LOGGER.isDebugEnabled()) {
            String messagePattern = "[{}],propertyName:[{}],value:[{}],ignoreCase:[{}],constants not found";
            LOGGER.debug(Slf4jUtil.format(messagePattern, enumClass, propertyName, specifiedValue, ignoreCase));
        }
        return null;
    }

    private static <T> boolean isEquals(Object propertyValue, T specifiedValue, boolean ignoreCase) {
        if (propertyValue == null || specifiedValue == null) {
            return propertyValue == specifiedValue;
        }
        if (propertyValue == specifiedValue) {
            return true;
        }
        String propertyValueString = propertyValue.toString();
        String specifiedValueString = specifiedValue.toString();
        return ignoreCase ? StringUtils.equalsIgnoreCase(propertyValueString, specifiedValueString) : StringUtils.equals(propertyValueString, specifiedValueString);
    }
}

