/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.core.bean;

import com.feilong.core.bean.ConvertUtil;
import com.feilong.core.lang.ClassUtil;
import com.feilong.core.lang.ObjectUtil;
import com.feilong.core.util.transformer.DateToStringTransformer;
import com.feilong.core.util.transformer.NumberToStringTransformer;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.collections4.Transformer;

public final class ToStringHandler {
    private static final Transformer<Date, String> DEFAULT_DATETOSTRING_TRANSFORMER = new DateToStringTransformer("yyyy-MM-dd HH:mm:ss");
    private static final Transformer<Number, String> DEFAULT_NUMBERTOSTRING_TRANSFORMER = new NumberToStringTransformer("#0.00");

    private ToStringHandler() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    static String toStringValue(Object toBeConvertedValue) {
        if (null == toBeConvertedValue) {
            return null;
        }
        if (ClassUtil.isInstance(toBeConvertedValue, CharSequence.class)) {
            return ((CharSequence)toBeConvertedValue).toString();
        }
        if (ObjectUtil.isArray(toBeConvertedValue)) {
            return ConvertUtil.toString((Object[])toBeConvertedValue, ",");
        }
        if (ClassUtil.isInstance(toBeConvertedValue, Collection.class)) {
            return ConvertUtil.toString((Collection)toBeConvertedValue, ",");
        }
        if (ClassUtil.isInstance(toBeConvertedValue, Date.class)) {
            return DEFAULT_DATETOSTRING_TRANSFORMER.transform((Date)toBeConvertedValue);
        }
        if (ClassUtil.isInstance(toBeConvertedValue, Calendar.class)) {
            return DEFAULT_DATETOSTRING_TRANSFORMER.transform(((Calendar)toBeConvertedValue).getTime());
        }
        if (ClassUtil.isInstanceAnyClass(toBeConvertedValue, BigDecimal.class, Double.class, Float.class)) {
            return DEFAULT_NUMBERTOSTRING_TRANSFORMER.transform((Number)toBeConvertedValue);
        }
        return ConvertUtil.convert(toBeConvertedValue, String.class);
    }
}

