/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.core.bean;

import com.feilong.core.Validate;
import com.feilong.core.Validator;
import com.feilong.core.bean.BeanOperationException;
import com.feilong.core.bean.PropertyValueObtainer;
import com.feilong.core.lang.ClassUtil;
import com.feilong.core.util.MapUtil;
import com.feilong.lib.beanutils.PropertyUtils;
import com.feilong.lib.lang3.ClassUtils;
import com.feilong.tools.slf4j.Slf4jUtil;
import java.beans.PropertyDescriptor;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertyUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyUtil.class);
    private static final String MESSAGE_BEAN_IS_NULL = "bean can't be null!";
    private static final String MESSAGE_PROPERTYNAME_IS_BLANK = "propertyName can't be blank!";

    private PropertyUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class<?> klass) {
        Validate.notNull(klass, "klass can't be null!", new Object[0]);
        try {
            return PropertyUtils.getPropertyDescriptors(klass);
        }
        catch (Exception e) {
            String pattern = "getPropertyDescriptors exception,klass:[{}]";
            throw new BeanOperationException(Slf4jUtil.format(pattern, klass), e);
        }
    }

    public static void copyProperties(Object toObj, Object fromObj, String ... includePropertyNames) {
        Validate.notNull(toObj, "toObj [destination bean] not specified!", new Object[0]);
        Validate.notNull(fromObj, "fromObj [origin bean] not specified!", new Object[0]);
        if (Validator.isNullOrEmpty(includePropertyNames)) {
            try {
                PropertyUtils.copyProperties(toObj, fromObj);
                return;
            }
            catch (Exception e) {
                String pattern = "copyProperties exception,toObj:[{}],fromObj:[{}],includePropertyNames:[{}]";
                throw new BeanOperationException(Slf4jUtil.format(pattern, toObj, fromObj, includePropertyNames), e);
            }
        }
        for (String propertyName : includePropertyNames) {
            Object value = PropertyUtil.getProperty(fromObj, propertyName);
            PropertyUtil.setProperty(toObj, propertyName, value);
        }
    }

    public static Map<String, Object> describe(Object bean, String ... propertyNames) {
        Validate.notNull(bean, MESSAGE_BEAN_IS_NULL, new Object[0]);
        if (Validator.isNullOrEmpty(propertyNames)) {
            try {
                return PropertyUtils.describe(bean);
            }
            catch (Exception e) {
                String pattern = "describe exception,bean:[{}],propertyNames:[{}]";
                throw new BeanOperationException(Slf4jUtil.format(pattern, bean, propertyNames), e);
            }
        }
        Map<String, Object> map = MapUtil.newLinkedHashMap(propertyNames.length);
        for (String propertyName : propertyNames) {
            map.put(propertyName, PropertyUtil.getProperty(bean, propertyName));
        }
        return map;
    }

    public static void setProperty(Object bean, String propertyName, Object value) {
        Validate.notNull(bean, MESSAGE_BEAN_IS_NULL, new Object[0]);
        Validate.notBlank(propertyName, MESSAGE_PROPERTYNAME_IS_BLANK, new Object[0]);
        try {
            PropertyUtils.setProperty(bean, propertyName, value);
        }
        catch (Exception e) {
            String pattern = "setProperty exception,bean:[{}],propertyName:[{}],value:[{}]";
            throw new BeanOperationException(Slf4jUtil.format(pattern, bean, propertyName, value), e);
        }
    }

    public static void setPropertyIfValueNotNullOrEmpty(Object bean, String propertyName, Object value) {
        if (Validator.isNotNullOrEmpty(value)) {
            PropertyUtil.setProperty(bean, propertyName, value);
        }
    }

    public static void setPropertyIfValueNotNull(Object bean, String propertyName, Object value) {
        if (null != value) {
            PropertyUtil.setProperty(bean, propertyName, value);
        }
    }

    public static <T> T getProperty(Object bean, String propertyName) {
        Validate.notNull(bean, MESSAGE_BEAN_IS_NULL, new Object[0]);
        Validate.notBlank(propertyName, MESSAGE_PROPERTYNAME_IS_BLANK, new Object[0]);
        return PropertyValueObtainer.obtain(bean, propertyName);
    }

    public static <T> T findValueOfType(Object obj, Class<T> toBeFindedClassType) {
        if (Validator.isNullOrEmpty(obj)) {
            return null;
        }
        Validate.notNull(toBeFindedClassType, "toBeFindedClassType can't be null/empty!", new Object[0]);
        if (ClassUtil.isInstance(obj, toBeFindedClassType)) {
            return (T)obj;
        }
        if (PropertyUtil.isDonotSupportFindType(obj)) {
            LOGGER.trace("obj:[{}] not support find toBeFindedClassType:[{}]", (Object)obj.getClass().getName(), (Object)toBeFindedClassType.getName());
            return null;
        }
        Map<String, Object> describe = PropertyUtil.describe(obj, new String[0]);
        for (Map.Entry<String, Object> entry : describe.entrySet()) {
            T t;
            String key = entry.getKey();
            Object value = entry.getValue();
            if (null == value || "class".equals(key) || null == (t = PropertyUtil.findValueOfType(value, toBeFindedClassType))) continue;
            return t;
        }
        return null;
    }

    private static boolean isDonotSupportFindType(Object obj) {
        return ClassUtils.isPrimitiveOrWrapper(obj.getClass()) || ClassUtil.isInstanceAnyClass(obj, CharSequence.class, Collection.class, Map.class);
    }
}

