/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.core.bean;

import com.feilong.core.bean.SpringBeanUtilsHelper;
import com.feilong.core.lang.reflect.MethodUtil;
import com.feilong.core.util.MapUtil;
import java.beans.PropertyDescriptor;
import java.util.Map;

public class PropertyDescriptorUtil {
    private static final String TYPE_SPRING = "spring";
    private static final String TYPE_COMMONS_BEANUTILS = "commons.beanutils";
    private static final Map<String, String> KEY_AND_TYPE_MAP = MapUtil.newConcurrentHashMap(200);

    private PropertyDescriptorUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    static boolean isUseSpringOperate(Class<?> klass, String propertyName) {
        String type = PropertyDescriptorUtil.getType(klass, propertyName);
        return TYPE_SPRING.equals(type);
    }

    private static String getType(Class<?> klass, String propertyName) {
        String key = PropertyDescriptorUtil.buildKey(klass, propertyName);
        if (KEY_AND_TYPE_MAP.containsKey(key)) {
            return KEY_AND_TYPE_MAP.get(key);
        }
        String type = PropertyDescriptorUtil.buildType(klass, propertyName);
        KEY_AND_TYPE_MAP.put(key, type);
        return type;
    }

    private static String buildType(Class<?> klass, String propertyName) {
        try {
            PropertyDescriptor springPropertyDescriptor = PropertyDescriptorUtil.getSpringPropertyDescriptor(klass, propertyName);
            if (null != springPropertyDescriptor) {
                return TYPE_SPRING;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return TYPE_COMMONS_BEANUTILS;
    }

    private static String buildKey(Class<? extends Object> klass, String propertyName) {
        return klass.getName() + "@@" + propertyName;
    }

    static PropertyDescriptor getSpringPropertyDescriptor(Class<?> klass, String propertyName) {
        if (SpringBeanUtilsHelper.hasSpringBeanUtilsClass()) {
            return (PropertyDescriptor)MethodUtil.invokeStaticMethod(SpringBeanUtilsHelper.getSpringBeanUtilsClass(), "getPropertyDescriptor", klass, propertyName);
        }
        return null;
    }
}

