/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.context.signer;

import com.feilong.context.signer.Signer;
import com.feilong.core.CharsetType;
import com.feilong.core.Validator;
import com.feilong.core.bean.ConvertUtil;
import com.feilong.security.oneway.SHA1Util;

public class SHA1Signer
implements Signer {
    private String key = SHA1Signer.class.getName();
    private String charsetName = CharsetType.UTF8;

    public SHA1Signer() {
    }

    public SHA1Signer(String key) {
        this.key = key;
    }

    public SHA1Signer(String key, String charsetName) {
        this.key = key;
        this.charsetName = charsetName;
    }

    @Override
    public String sign(CharSequence ... strs) {
        if (Validator.isNullOrEmpty(strs)) {
            return "";
        }
        String tobeSign = ConvertUtil.toString((Object[])strs, "");
        return SHA1Util.encode(tobeSign + this.key, this.charsetName);
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }
}

