/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.context.invoker;

import com.feilong.context.converter.StringToBeanConverter;
import com.feilong.context.invoker.InvokerRequest;
import com.feilong.context.invoker.InvokerResponseBlankException;
import com.feilong.context.invoker.ResponseCommand;
import com.feilong.context.invoker.ResponseCommandBuilder;
import com.feilong.context.invoker.ResponseStringBuilder;
import com.feilong.core.Validator;
import com.feilong.json.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultResponseCommandBuilder<R extends InvokerRequest, T extends ResponseCommand>
implements ResponseCommandBuilder<R, T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultResponseCommandBuilder.class);
    protected ResponseStringBuilder<R> responseStringBuilder;
    protected StringToBeanConverter<T> stringToBeanConverter;

    @Override
    public T build(R request) {
        String invokerResponseString = this.responseStringBuilder.build(request);
        if (Validator.isNullOrEmpty(invokerResponseString)) {
            throw new InvokerResponseBlankException("invokerResponse can't be null/empty!,request:[{}]", JsonUtil.format(request));
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("NetpayRequest:[{}],invokerResponse:[{}]", (Object)JsonUtil.format(request), (Object)invokerResponseString);
        }
        return (T)((ResponseCommand)this.stringToBeanConverter.convert(invokerResponseString));
    }

    public void setResponseStringBuilder(ResponseStringBuilder<R> responseStringBuilder) {
        this.responseStringBuilder = responseStringBuilder;
    }

    public void setStringToBeanConverter(StringToBeanConverter<T> stringToBeanConverter) {
        this.stringToBeanConverter = stringToBeanConverter;
    }
}

