/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.context.invoker;

import com.feilong.context.Rebuilder;
import com.feilong.context.format.JsonStringFormatter;
import com.feilong.context.format.StringFormatter;
import com.feilong.context.format.XMLStringFormatter;
import com.feilong.context.invoker.ResponseStringBuilder;
import com.feilong.core.Validator;
import com.feilong.json.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResponseStringBuilder<T>
implements ResponseStringBuilder<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractResponseStringBuilder.class);
    private String format;
    private StringFormatter stringFormatter;
    private Rebuilder<String> responseStringRebuilder;

    @Override
    public String build(T request) {
        String responseString = this.handler(request);
        if (null == this.responseStringRebuilder) {
            this.logMessage(request, responseString);
            return responseString;
        }
        String rebuildResult = this.responseStringRebuilder.rebuild(responseString);
        this.logMessage(request, responseString, this.responseStringRebuilder, rebuildResult);
        return rebuildResult;
    }

    protected abstract String handler(T var1);

    private void logMessage(T request, String responseString) {
        if (LOGGER.isDebugEnabled()) {
            String response = this.formatResponse(responseString);
            LOGGER.debug("request:[{}],responseString:[{}]", (Object)JsonUtil.format(request), (Object)response);
        }
    }

    private void logMessage(T request, String responseString, Rebuilder<String> rebuilder, String rebuildResult) {
        if (LOGGER.isInfoEnabled()) {
            String response = this.formatResponse(responseString);
            LOGGER.info("request:[{}],responseString:[{}],after use rebuilder:[{}],will return:[{}]", new Object[]{JsonUtil.format(request), response, rebuilder.getClass().getCanonicalName(), rebuildResult});
        }
    }

    private String formatResponse(String responseString) {
        if (null != this.stringFormatter) {
            return this.stringFormatter.format(responseString);
        }
        if (Validator.isNotNullOrEmpty(this.format)) {
            String formatValue = this.format.trim();
            if (formatValue.equalsIgnoreCase("xml")) {
                return XMLStringFormatter.INSTANCE.format(responseString);
            }
            if (formatValue.equalsIgnoreCase("json")) {
                return JsonStringFormatter.INSTANCE.format(responseString);
            }
        }
        return responseString;
    }

    public void setStringFormatter(StringFormatter stringFormatter) {
        this.stringFormatter = stringFormatter;
    }

    public void setResponseStringRebuilder(Rebuilder<String> responseStringRebuilder) {
        this.responseStringRebuilder = responseStringRebuilder;
    }

    public void setFormat(String format) {
        this.format = format;
    }
}

