/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.context;

import com.feilong.context.StringValueParamLoader;
import com.feilong.context.ValueLoader;
import com.feilong.core.Validate;
import com.feilong.core.bean.ConvertUtil;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleParamNameValueLoader<V>
implements ValueLoader<V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleParamNameValueLoader.class);
    private String paramName;
    private Class<V> targetTypeClass;
    private V ifNullDefaultValue = null;
    private StringValueParamLoader<V> stringValueParamLoader;

    @PostConstruct
    protected void postConstruct() {
        Validate.notBlank(this.paramName, "paramName can't be blank!", new Object[0]);
        Validate.notNull(this.stringValueParamLoader, "stringValueParamLoader can't be null!", new Object[0]);
    }

    @Override
    public V load() {
        Object value = this.stringValueParamLoader.load(this.paramName);
        if (null == value) {
            return this.doWithDefaultValue();
        }
        return this.doWithLoadValue(value);
    }

    private V doWithLoadValue(V value) {
        String valueClassName = value.getClass().getName();
        if (null == this.targetTypeClass) {
            LOGGER.debug("when param:[{}],return value:[{}],type:[{}],no config targetTypeClass", new Object[]{this.paramName, value, valueClassName});
            return value;
        }
        V convertResult = ConvertUtil.convert(value, this.targetTypeClass);
        LOGGER.debug("when param:[{}],load value:[{}],type:[{}],convert to:[{}],return:[{}]", new Object[]{this.paramName, value, valueClassName, this.targetTypeClass.getName(), convertResult});
        return convertResult;
    }

    private V doWithDefaultValue() {
        if (null == this.ifNullDefaultValue) {
            LOGGER.debug("when param:[{}],load value is null,return defaultValue null", (Object)this.paramName);
            return null;
        }
        if (null == this.targetTypeClass) {
            LOGGER.debug("when param:[{}],load value is null,return defaultValue:[{}]", (Object)this.paramName, this.ifNullDefaultValue);
            return this.ifNullDefaultValue;
        }
        V convertResult = ConvertUtil.convert(this.ifNullDefaultValue, this.targetTypeClass);
        LOGGER.debug("when param:[{}],load value is null,use targetTypeClass:[{}],return defaultValue:[{}]", new Object[]{this.paramName, this.targetTypeClass.getName(), convertResult});
        return convertResult;
    }

    public void setParamName(String paramName) {
        this.paramName = paramName;
    }

    public void setTargetTypeClass(Class<V> targetTypeClass) {
        this.targetTypeClass = targetTypeClass;
    }

    public void setIfNullDefaultValue(V ifNullDefaultValue) {
        this.ifNullDefaultValue = ifNullDefaultValue;
    }

    public void setStringValueParamLoader(StringValueParamLoader<V> stringValueParamLoader) {
        this.stringValueParamLoader = stringValueParamLoader;
    }
}

