/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.context;

import com.feilong.context.Data;
import com.feilong.context.DataListQuery;
import com.feilong.context.Task;
import com.feilong.core.Validator;
import com.feilong.core.date.DateUtil;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataListTask<T extends Data>
implements Task<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDataListTask.class);
    private DataListQuery<T> dataListQuery;

    @Override
    public Void run() {
        Date beginDate = new Date();
        String taskName = this.getClass().getName();
        List<T> dataList = this.dataListQuery.query();
        if (Validator.isNullOrEmpty(dataList)) {
            if (LOGGER.isInfoEnabled()) {
                String name = this.dataListQuery.getClass().getName();
                LOGGER.info("[{}],use dataListQuery:[{}] query no data list,use time: [{}]", new Object[]{taskName, name, DateUtil.formatDuration(beginDate)});
            }
            return null;
        }
        this.handle(dataList);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("[{}],dataList size:[{}],use time: [{}]", new Object[]{taskName, dataList.size(), DateUtil.formatDuration(beginDate)});
        }
        return null;
    }

    protected abstract void handle(List<T> var1);

    public void setDataListQuery(DataListQuery<T> dataListQuery) {
        this.dataListQuery = dataListQuery;
    }
}

