/*
 * Decompiled with CFR 0.152.
 */
package com.icebuf.util;

import com.icebuf.util.Base64;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AESUtil {
    private static final String KEY_ALGORITHM = "AES";
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES/CBC/PKCS5Padding";
    private static String sCipherAlgorithm = "AES/CBC/PKCS5Padding";
    private static final int KEY_LENGTH = 16;
    private static final String DEFAULT_VALUE = "0";

    public static void setCipherAlgorithm(String cipherAlgorithm) {
        sCipherAlgorithm = cipherAlgorithm;
    }

    public static String encrypt(String key, String src) throws Exception {
        src = Base64.encodeToString(src.getBytes(), 0);
        byte[] rawKey = AESUtil.makeKey(key, 16, DEFAULT_VALUE).getBytes();
        byte[] result = AESUtil.getBytes(rawKey, src.getBytes(StandardCharsets.UTF_8), 1);
        result = Base64.encode(result, 0);
        return new String(result, StandardCharsets.UTF_8);
    }

    public static String decrypt(String key, String encrypted) throws Exception {
        byte[] rawKey = AESUtil.makeKey(key, 16, DEFAULT_VALUE).getBytes();
        encrypted = encrypted.replace("\r\n", "");
        byte[] enc = encrypted.getBytes(StandardCharsets.UTF_8);
        enc = Base64.decode(enc, 0);
        byte[] result = AESUtil.getBytes(rawKey, enc, 2);
        result = Base64.decode(result, 0);
        return new String(result, StandardCharsets.UTF_8);
    }

    private static String makeKey(String key, int length, String text) {
        int strLen = key.length();
        if (strLen < length) {
            StringBuilder builder = new StringBuilder();
            builder.append(key);
            for (int i = 0; i < length - strLen; ++i) {
                builder.append(text);
            }
            key = builder.toString();
        }
        return key;
    }

    private static byte[] getBytes(byte[] key, byte[] src, int mode) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        SecretKeySpec secretKeySpec = new SecretKeySpec(key, KEY_ALGORITHM);
        Cipher cipher = Cipher.getInstance(sCipherAlgorithm);
        cipher.init(mode, (Key)secretKeySpec, new IvParameterSpec(new byte[cipher.getBlockSize()]));
        return cipher.doFinal(src);
    }
}

