/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.bluetooth;

import com.github.hypfvieh.DbusHelper;
import com.github.hypfvieh.bluetooth.DiscoveryFilter;
import com.github.hypfvieh.bluetooth.wrapper.BluetoothAdapter;
import com.github.hypfvieh.bluetooth.wrapper.BluetoothDevice;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bluez.Adapter1;
import org.bluez.Device1;
import org.bluez.exceptions.BluezDoesNotExistException;
import org.bluez.exceptions.BluezFailedException;
import org.bluez.exceptions.BluezInvalidArgumentsException;
import org.bluez.exceptions.BluezNotReadyException;
import org.bluez.exceptions.BluezNotSupportedException;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.handlers.AbstractPropertiesChangedHandler;
import org.freedesktop.dbus.handlers.AbstractSignalHandlerBase;
import org.freedesktop.dbus.interfaces.DBusSigHandler;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.dbus.types.Variant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceManager {
    private static DeviceManager INSTANCE;
    private DBusConnection dbusConnection;
    private final Map<String, BluetoothAdapter> bluetoothAdaptersByMac = new LinkedHashMap<String, BluetoothAdapter>();
    private final Map<String, BluetoothAdapter> bluetoothAdaptersByAdapterName = new LinkedHashMap<String, BluetoothAdapter>();
    private final Map<String, List<BluetoothDevice>> bluetoothDeviceByAdapterMac = new LinkedHashMap<String, List<BluetoothDevice>>();
    private String defaultAdapterMac;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    private DeviceManager(DBusConnection _connection) {
        this.dbusConnection = Objects.requireNonNull(_connection);
    }

    public static DeviceManager createInstance(boolean _sessionConnection) throws DBusException {
        INSTANCE = new DeviceManager(DBusConnection.getConnection((DBusConnection.DBusBusType)(_sessionConnection ? DBusConnection.DBusBusType.SESSION : DBusConnection.DBusBusType.SYSTEM)));
        return INSTANCE;
    }

    public void closeConnection() {
        this.dbusConnection.disconnect();
    }

    public static DeviceManager createInstance(String _address) throws DBusException {
        if (_address == null) {
            throw new DBusException("Null is not a valid address");
        }
        INSTANCE = new DeviceManager(DBusConnection.getConnection((String)_address));
        return INSTANCE;
    }

    public static DeviceManager getInstance() {
        if (INSTANCE == null) {
            throw new IllegalStateException("Instance not created yet. Please use " + DeviceManager.class.getSimpleName() + ".createInstance() first");
        }
        return INSTANCE;
    }

    public List<BluetoothAdapter> scanForBluetoothAdapters() {
        this.bluetoothAdaptersByAdapterName.clear();
        this.bluetoothAdaptersByMac.clear();
        Set<String> scanObjectManager = DbusHelper.findNodes(this.dbusConnection, "/org/bluez");
        for (String hci : scanObjectManager) {
            Adapter1 adapter = DbusHelper.getRemoteObject(this.dbusConnection, "/org/bluez/" + hci, Adapter1.class);
            if (adapter == null) continue;
            BluetoothAdapter bt2 = new BluetoothAdapter(adapter, "/org/bluez/" + hci, this.dbusConnection);
            this.bluetoothAdaptersByMac.put(bt2.getAddress(), bt2);
            this.bluetoothAdaptersByAdapterName.put(hci, bt2);
        }
        ArrayList<BluetoothAdapter> adapterList = new ArrayList<BluetoothAdapter>(this.bluetoothAdaptersByAdapterName.values());
        if (this.defaultAdapterMac == null && !this.bluetoothAdaptersByMac.isEmpty()) {
            this.defaultAdapterMac = new ArrayList<String>(this.bluetoothAdaptersByMac.keySet()).get(0);
        }
        return adapterList;
    }

    public List<BluetoothDevice> scanForBluetoothDevices(int _timeout) {
        return this.scanForBluetoothDevices(this.defaultAdapterMac, _timeout);
    }

    public List<BluetoothDevice> scanForBluetoothDevices(String _adapter, int _timeoutMs) {
        List<BluetoothDevice> devicelist;
        BluetoothAdapter adapter = this.getAdapter(_adapter);
        if (adapter == null) {
            return new ArrayList<BluetoothDevice>();
        }
        if (adapter.startDiscovery()) {
            try {
                Thread.sleep(_timeoutMs);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            adapter.stopDiscovery();
            this.findBtDevicesByIntrospection(adapter);
        }
        if ((devicelist = this.bluetoothDeviceByAdapterMac.get(adapter.getAddress())) != null) {
            return new ArrayList<BluetoothDevice>(devicelist);
        }
        return new ArrayList<BluetoothDevice>();
    }

    public void findBtDevicesByIntrospection(BluetoothAdapter adapter) {
        Set<String> scanObjectManager = DbusHelper.findNodes(this.dbusConnection, adapter.getDbusPath());
        String adapterMac = adapter.getAddress();
        if (this.bluetoothDeviceByAdapterMac.containsKey(adapterMac)) {
            this.bluetoothDeviceByAdapterMac.get(adapterMac).clear();
        }
        for (String path : scanObjectManager) {
            String devicePath = "/org/bluez/" + adapter.getDeviceName() + "/" + path;
            Device1 device = DbusHelper.getRemoteObject(this.dbusConnection, devicePath, Device1.class);
            if (device == null) continue;
            BluetoothDevice btDev = new BluetoothDevice(device, adapter, devicePath, this.dbusConnection);
            this.logger.debug("Found bluetooth device {} on adapter {}", (Object)btDev.getAddress(), (Object)adapterMac);
            if (this.bluetoothDeviceByAdapterMac.containsKey(adapterMac)) {
                this.bluetoothDeviceByAdapterMac.get(adapterMac).add(btDev);
                continue;
            }
            ArrayList<BluetoothDevice> list = new ArrayList<BluetoothDevice>();
            list.add(btDev);
            this.bluetoothDeviceByAdapterMac.put(adapterMac, list);
        }
    }

    public void setScanFilter(Map<DiscoveryFilter, Object> _filter) throws BluezInvalidArgumentsException, BluezNotReadyException, BluezNotSupportedException, BluezFailedException {
        LinkedHashMap filters = new LinkedHashMap();
        for (Map.Entry<DiscoveryFilter, Object> entry : _filter.entrySet()) {
            if (!entry.getKey().getValueClass().isInstance(entry.getValue())) {
                throw new BluezInvalidArgumentsException("Filter value not of required type " + entry.getKey().getValueClass());
            }
            if (entry.getValue() instanceof Enum) {
                filters.put(entry.getKey().name(), new Variant((Object)entry.getValue().toString()));
                continue;
            }
            filters.put(entry.getKey().name(), new Variant(entry.getValue()));
        }
        this.getAdapter().setDiscoveryFilter(filters);
    }

    public BluetoothAdapter getAdapter() {
        if (this.defaultAdapterMac != null && this.bluetoothAdaptersByMac.containsKey(this.defaultAdapterMac)) {
            return this.bluetoothAdaptersByMac.get(this.defaultAdapterMac);
        }
        return this.scanForBluetoothAdapters().get(0);
    }

    public BluetoothAdapter getAdapter(String _ident) {
        if (_ident == null && this.defaultAdapterMac == null) {
            this.scanForBluetoothAdapters();
        }
        if (_ident == null) {
            _ident = this.defaultAdapterMac;
        }
        if (this.bluetoothAdaptersByMac.containsKey(_ident)) {
            return this.bluetoothAdaptersByMac.get(_ident);
        }
        if (this.bluetoothAdaptersByAdapterName.containsKey(_ident)) {
            return this.bluetoothAdaptersByAdapterName.get(_ident);
        }
        List<BluetoothAdapter> scanForBluetoothAdapters = this.scanForBluetoothAdapters();
        if (!scanForBluetoothAdapters.isEmpty()) {
            if (this.bluetoothAdaptersByMac.containsKey(_ident)) {
                return this.bluetoothAdaptersByMac.get(_ident);
            }
            if (this.bluetoothAdaptersByAdapterName.containsKey(_ident)) {
                return this.bluetoothAdaptersByAdapterName.get(_ident);
            }
        }
        return null;
    }

    public List<BluetoothAdapter> getAdapters() {
        if (this.bluetoothAdaptersByMac.isEmpty()) {
            this.scanForBluetoothAdapters();
        }
        return new ArrayList<BluetoothAdapter>(this.bluetoothAdaptersByMac.values());
    }

    public List<BluetoothDevice> getDevices() {
        return this.getDevices(this.defaultAdapterMac);
    }

    public List<BluetoothDevice> getDevices(boolean _doNotScan) {
        return this.getDevices(this.defaultAdapterMac, _doNotScan);
    }

    public List<BluetoothDevice> getDevices(String _adapterMac) {
        return this.getDevices(_adapterMac, false);
    }

    public List<BluetoothDevice> getDevices(String _adapterMac, boolean _doNotScan) {
        if (_doNotScan) {
            this.findBtDevicesByIntrospection(this.getAdapter(_adapterMac));
        } else if (this.bluetoothDeviceByAdapterMac.isEmpty()) {
            this.scanForBluetoothDevices(_adapterMac, 5000);
        }
        return this.bluetoothDeviceByAdapterMac.getOrDefault(_adapterMac, new ArrayList());
    }

    public void setDefaultAdapter(String _adapterMac) throws BluezDoesNotExistException {
        if (this.bluetoothAdaptersByMac.isEmpty()) {
            this.scanForBluetoothAdapters();
        }
        if (!this.bluetoothAdaptersByMac.containsKey(_adapterMac)) {
            throw new BluezDoesNotExistException("Could not find bluetooth adapter with MAC address: " + _adapterMac);
        }
        this.defaultAdapterMac = _adapterMac;
    }

    public void setDefaultAdapter(BluetoothAdapter _adapter) throws BluezDoesNotExistException {
        if (_adapter == null) {
            throw new BluezDoesNotExistException("Null is not a valid bluetooth adapter");
        }
        this.setDefaultAdapter(_adapter.getAddress());
    }

    public void registerPropertyHandler(AbstractPropertiesChangedHandler _handler) throws DBusException {
        this.dbusConnection.addSigHandler(_handler.getImplementationClass(), (DBusSigHandler)_handler);
    }

    public void unRegisterPropertyHandler(AbstractPropertiesChangedHandler _handler) throws DBusException {
        this.dbusConnection.removeSigHandler(_handler.getImplementationClass(), (DBusSigHandler)_handler);
    }

    public <T extends DBusSignal> void registerSignalHandler(AbstractSignalHandlerBase<T> _handler) throws DBusException {
        this.dbusConnection.addSigHandler(_handler.getImplementationClass(), _handler);
    }

    public <T extends DBusSignal> void unRegisterSignalHandler(AbstractSignalHandlerBase<T> _handler) throws DBusException {
        this.dbusConnection.removeSigHandler(_handler.getImplementationClass(), _handler);
    }

    public DBusConnection getDbusConnection() {
        return this.dbusConnection;
    }
}

