/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc;

import com.github.housepower.client.NativeClient;
import com.github.housepower.client.NativeContext;
import com.github.housepower.client.SessionState;
import com.github.housepower.data.Block;
import com.github.housepower.data.DataTypeFactory;
import com.github.housepower.jdbc.ClickHouseArray;
import com.github.housepower.jdbc.ClickHouseDatabaseMetadata;
import com.github.housepower.jdbc.ClickHouseStruct;
import com.github.housepower.jdbc.statement.ClickHousePreparedInsertStatement;
import com.github.housepower.jdbc.statement.ClickHousePreparedQueryStatement;
import com.github.housepower.jdbc.statement.ClickHouseStatement;
import com.github.housepower.jdbc.wrapper.SQLConnection;
import com.github.housepower.log.Logger;
import com.github.housepower.log.LoggerFactory;
import com.github.housepower.misc.Validate;
import com.github.housepower.protocol.HelloResponse;
import com.github.housepower.settings.ClickHouseConfig;
import com.github.housepower.stream.QueryResult;
import java.net.InetSocketAddress;
import java.sql.Array;
import java.sql.ClientInfoStatus;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Struct;
import java.time.Duration;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class ClickHouseConnection
implements SQLConnection {
    private static final Logger LOG = LoggerFactory.getLogger(ClickHouseConnection.class);
    private static final Pattern VALUES_REGEX = Pattern.compile("[Vv][Aa][Ll][Uu][Ee][Ss]\\s*\\(");
    private final AtomicBoolean isClosed;
    private final AtomicReference<ClickHouseConfig> cfg;
    private final AtomicReference<SessionState> state = new AtomicReference<SessionState>(SessionState.IDLE);
    private volatile NativeContext nativeCtx;

    protected ClickHouseConnection(ClickHouseConfig cfg, NativeContext nativeCtx) {
        this.isClosed = new AtomicBoolean(false);
        this.cfg = new AtomicReference<ClickHouseConfig>(cfg);
        this.nativeCtx = nativeCtx;
    }

    public ClickHouseConfig cfg() {
        return this.cfg.get();
    }

    public NativeContext.ServerContext serverContext() {
        return this.nativeCtx.serverCtx();
    }

    public NativeContext.ClientContext clientContext() {
        return this.nativeCtx.clientCtx();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return true;
    }

    @Override
    public void commit() throws SQLException {
    }

    @Override
    public void rollback() throws SQLException {
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return null;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
    }

    @Override
    public int getHoldability() throws SQLException {
        return 2;
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.close();
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed() && this.isClosed.compareAndSet(false, true)) {
            NativeClient nativeClient = this.nativeCtx.nativeClient();
            nativeClient.disconnect();
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed.get();
    }

    @Override
    public Statement createStatement() throws SQLException {
        Validate.isTrue(!this.isClosed(), "Unable to create Statement, because the connection is closed.");
        return new ClickHouseStatement(this, this.nativeCtx);
    }

    @Override
    public PreparedStatement prepareStatement(String query) throws SQLException {
        Validate.isTrue(!this.isClosed(), "Unable to create PreparedStatement, because the connection is closed.");
        Matcher matcher = VALUES_REGEX.matcher(query);
        return matcher.find() ? new ClickHousePreparedInsertStatement(matcher.end() - 1, query, this, this.nativeCtx) : new ClickHousePreparedQueryStatement(this, this.nativeCtx, query);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.cfg.set(ClickHouseConfig.Builder.builder(this.cfg.get()).withProperties(properties).build());
        }
        catch (Exception ex) {
            HashMap<String, ClientInfoStatus> failed = new HashMap<String, ClientInfoStatus>();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                failed.put((String)entry.getKey(), ClientInfoStatus.REASON_UNKNOWN);
            }
            throw new SQLClientInfoException(failed, (Throwable)ex);
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        Properties properties = new Properties();
        properties.put(name, value);
        this.setClientInfo(properties);
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        Validate.isTrue(!this.isClosed(), "Unable to create Array, because the connection is closed.");
        return new ClickHouseArray(DataTypeFactory.get(typeName, this.nativeCtx.serverCtx()), elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        Validate.isTrue(!this.isClosed(), "Unable to create Struct, because the connection is closed.");
        return new ClickHouseStruct(typeName, attributes);
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.getNativeClient().ping(Duration.ofSeconds(timeout), this.nativeCtx.serverCtx());
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.cfg.set(this.cfg().withDatabase(schema));
    }

    @Override
    @Nullable
    public String getSchema() throws SQLException {
        return this.cfg().database();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
    }

    @Override
    public String getCatalog() throws SQLException {
        return null;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new ClickHouseDatabaseMetadata(this.cfg().jdbcUrl(), this);
    }

    @Override
    public Logger logger() {
        return LOG;
    }

    public boolean ping(Duration timeout) throws SQLException {
        return this.nativeCtx.nativeClient().ping(timeout, this.nativeCtx.serverCtx());
    }

    public Block getSampleBlock(String insertQuery) throws SQLException {
        NativeClient nativeClient = this.getHealthyNativeClient();
        nativeClient.sendQuery(insertQuery, this.nativeCtx.clientCtx(), this.cfg.get().settings());
        Validate.isTrue(this.state.compareAndSet(SessionState.IDLE, SessionState.WAITING_INSERT), "Connection is currently waiting for an insert operation, check your previous InsertStatement.");
        return nativeClient.receiveSampleBlock(this.cfg.get().queryTimeout(), this.nativeCtx.serverCtx());
    }

    public QueryResult sendQueryRequest(String query, ClickHouseConfig cfg) throws SQLException {
        Validate.isTrue(this.state.get() == SessionState.IDLE, "Connection is currently waiting for an insert operation, check your previous InsertStatement.");
        NativeClient nativeClient = this.getHealthyNativeClient();
        nativeClient.sendQuery(query, this.nativeCtx.clientCtx(), cfg.settings());
        return nativeClient.receiveQuery(cfg.queryTimeout(), this.nativeCtx.serverCtx());
    }

    public int sendInsertRequest(Block block) throws SQLException {
        Validate.isTrue(this.state.get() == SessionState.WAITING_INSERT, "Call getSampleBlock before insert.");
        try {
            NativeClient nativeClient = this.getNativeClient();
            nativeClient.sendData(block);
            nativeClient.sendData(new Block());
            nativeClient.receiveEndOfStream(this.cfg.get().queryTimeout(), this.nativeCtx.serverCtx());
        }
        finally {
            Validate.isTrue(this.state.compareAndSet(SessionState.WAITING_INSERT, SessionState.IDLE));
        }
        return block.rowCnt();
    }

    private synchronized NativeClient getHealthyNativeClient() throws SQLException {
        NativeContext oldCtx = this.nativeCtx;
        if (!oldCtx.nativeClient().ping(this.cfg.get().queryTimeout(), this.nativeCtx.serverCtx())) {
            LOG.warn("connection loss with state[{}], create new connection and reset state", this.state);
            this.nativeCtx = ClickHouseConnection.createNativeContext(this.cfg.get());
            this.state.set(SessionState.IDLE);
            oldCtx.nativeClient().silentDisconnect();
        }
        return this.nativeCtx.nativeClient();
    }

    private NativeClient getNativeClient() {
        return this.nativeCtx.nativeClient();
    }

    public static ClickHouseConnection createClickHouseConnection(ClickHouseConfig configure) throws SQLException {
        return new ClickHouseConnection(configure, ClickHouseConnection.createNativeContext(configure));
    }

    private static NativeContext createNativeContext(ClickHouseConfig configure) throws SQLException {
        if (configure.hosts().size() == 1) {
            NativeClient nativeClient = NativeClient.connect(configure);
            return new NativeContext(ClickHouseConnection.clientContext(nativeClient, configure), ClickHouseConnection.serverContext(nativeClient, configure), nativeClient);
        }
        return ClickHouseConnection.createFailoverNativeContext(configure);
    }

    private static NativeContext createFailoverNativeContext(ClickHouseConfig configure) throws SQLException {
        NativeClient nativeClient = null;
        SQLException lastException = null;
        int tryIndex = 0;
        do {
            String hostAndPort = configure.hosts().get(tryIndex);
            String[] hostAndPortSplit = hostAndPort.split(":", 2);
            String host = hostAndPortSplit[0];
            int port = hostAndPortSplit.length == 2 ? Integer.parseInt(hostAndPortSplit[1]) : configure.port();
            try {
                nativeClient = NativeClient.connect(host, port, configure);
            }
            catch (SQLException e) {
                lastException = e;
            }
        } while (nativeClient == null && ++tryIndex < configure.hosts().size());
        if (nativeClient == null) {
            throw lastException;
        }
        return new NativeContext(ClickHouseConnection.clientContext(nativeClient, configure), ClickHouseConnection.serverContext(nativeClient, configure), nativeClient);
    }

    private static NativeContext.ClientContext clientContext(NativeClient nativeClient, ClickHouseConfig configure) throws SQLException {
        Validate.isTrue(nativeClient.address() instanceof InetSocketAddress);
        InetSocketAddress address = (InetSocketAddress)nativeClient.address();
        String clientName = configure.clientName();
        String initialAddress = "[::ffff:127.0.0.1]:0";
        return new NativeContext.ClientContext(initialAddress, address.getHostName(), clientName);
    }

    private static NativeContext.ServerContext serverContext(NativeClient nativeClient, ClickHouseConfig configure) throws SQLException {
        try {
            long revision = 54380L;
            nativeClient.sendHello("client", revision, configure.database(), configure.user(), configure.password());
            HelloResponse response = nativeClient.receiveHello(configure.queryTimeout(), null);
            ZoneId timeZone = ZoneId.of(response.serverTimeZone());
            return new NativeContext.ServerContext(response.majorVersion(), response.minorVersion(), response.reversion(), configure, timeZone, response.serverDisplayName());
        }
        catch (SQLException rethrows) {
            nativeClient.silentDisconnect();
            throw rethrows;
        }
    }
}

