/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.data.type;

import com.github.housepower.data.IDataType;
import com.github.housepower.misc.SQLLexer;
import com.github.housepower.serde.BinaryDeserializer;
import com.github.housepower.serde.BinarySerializer;
import java.io.IOException;
import java.math.BigInteger;
import java.sql.SQLException;

public class DataTypeIPv6
implements IDataType<BigInteger, BigInteger> {
    @Override
    public String name() {
        return "IPv6";
    }

    @Override
    public int sqlTypeId() {
        return -5;
    }

    @Override
    public BigInteger defaultValue() {
        return BigInteger.ZERO;
    }

    @Override
    public Class<BigInteger> javaType() {
        return BigInteger.class;
    }

    @Override
    public int getPrecision() {
        return 0;
    }

    @Override
    public int getScale() {
        return 39;
    }

    @Override
    public void serializeBinary(BigInteger data, BinarySerializer serializer) throws SQLException, IOException {
        byte[] bytes = data.toByteArray();
        if (bytes.length > 16) {
            throw new SQLException("IPv6 representation exceeds 16 bytes.");
        }
        byte[] paddedBytes = new byte[16];
        int offset = 16 - bytes.length;
        System.arraycopy(bytes, 0, paddedBytes, offset, bytes.length);
        serializer.writeBytes(paddedBytes, 0, paddedBytes.length);
    }

    @Override
    public BigInteger deserializeBinary(BinaryDeserializer deserializer) throws SQLException, IOException {
        byte[] bytes = deserializer.readBytes(16);
        return new BigInteger(1, bytes);
    }

    @Override
    public String[] getAliases() {
        return new String[0];
    }

    @Override
    public BigInteger deserializeText(SQLLexer lexer) throws SQLException {
        String ipv6String = DataTypeIPv6.convertIPv6ToHexadecimalString(lexer.stringLiteral());
        return new BigInteger(ipv6String, 16);
    }

    private static String convertIPv6ToHexadecimalString(String ipv6) {
        return ipv6.replace(":", "");
    }
}

