/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.data.type;

import com.github.housepower.data.IDataType;
import com.github.housepower.misc.SQLLexer;
import com.github.housepower.serde.BinaryDeserializer;
import com.github.housepower.serde.BinarySerializer;
import java.io.IOException;
import java.sql.SQLException;

public class DataTypeFloat32
implements IDataType<Float, Float> {
    @Override
    public String name() {
        return "Float32";
    }

    @Override
    public int sqlTypeId() {
        return 6;
    }

    @Override
    public Float defaultValue() {
        return Float.valueOf(0.0f);
    }

    @Override
    public Class<Float> javaType() {
        return Float.class;
    }

    @Override
    public int getPrecision() {
        return 8;
    }

    @Override
    public int getScale() {
        return 8;
    }

    @Override
    public void serializeBinary(Float data, BinarySerializer serializer) throws SQLException, IOException {
        serializer.writeFloat(data.floatValue());
    }

    @Override
    public Float deserializeBinary(BinaryDeserializer deserializer) throws IOException {
        return Float.valueOf(deserializer.readFloat());
    }

    @Override
    public String[] getAliases() {
        return new String[]{"FLOAT"};
    }

    @Override
    public Float deserializeText(SQLLexer lexer) throws SQLException {
        return Float.valueOf(lexer.numberLiteral().floatValue());
    }

    @Override
    public boolean isSigned() {
        return true;
    }
}

