/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbie.lesscss.utils;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.Encoder;
import com.github.houbie.lesscss.LessCompilerImpl;
import com.github.houbie.lesscss.builder.CompilationTask;
import com.github.houbie.lesscss.engine.LessCompilationEngine;
import org.slf4j.LoggerFactory;

public class LogbackConfigurator {
    public static void configure(boolean verbose, boolean daemon) {
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        ConsoleAppender ca = new ConsoleAppender();
        ca.setContext((Context)lc);
        ca.setName("less console");
        PatternLayoutEncoder pl = new PatternLayoutEncoder();
        pl.setContext((Context)lc);
        pl.setPattern("%msg%n");
        pl.start();
        ca.setEncoder((Encoder)pl);
        ca.start();
        lc.getLogger("ROOT").detachAndStopAllAppenders();
        LogbackConfigurator.configureCompilerLogger(verbose, lc, (ConsoleAppender<ILoggingEvent>)ca);
        LogbackConfigurator.configureCompilationTaskLogger(daemon, lc, (ConsoleAppender<ILoggingEvent>)ca);
        LogbackConfigurator.configureLessCompilationEngineLogger(verbose, lc, (ConsoleAppender<ILoggingEvent>)ca);
    }

    private static void configureCompilerLogger(boolean verbose, LoggerContext lc, ConsoleAppender<ILoggingEvent> ca) {
        Logger compilerLogger = lc.getLogger(LessCompilerImpl.class);
        compilerLogger.detachAndStopAllAppenders();
        compilerLogger.addAppender(ca);
        compilerLogger.setLevel(verbose ? Level.ALL : Level.OFF);
    }

    private static void configureCompilationTaskLogger(boolean daemon, LoggerContext lc, ConsoleAppender<ILoggingEvent> ca) {
        Logger compilationTaskLogger = lc.getLogger(CompilationTask.class);
        compilationTaskLogger.detachAndStopAllAppenders();
        compilationTaskLogger.addAppender(ca);
        compilationTaskLogger.setLevel(daemon ? Level.INFO : Level.OFF);
    }

    private static void configureLessCompilationEngineLogger(boolean verbose, LoggerContext lc, ConsoleAppender<ILoggingEvent> ca) {
        Logger engineLogger = lc.getLogger(LessCompilationEngine.class.getPackage().getName());
        engineLogger.detachAndStopAllAppenders();
        engineLogger.addAppender(ca);
        engineLogger.setLevel(verbose ? Level.ALL : Level.OFF);
    }
}

