/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbie.lesscss.resourcereader;

import com.github.houbie.lesscss.resourcereader.ResourceReader;
import java.io.IOException;

public class CombiningResourceReader
implements ResourceReader {
    private ResourceReader[] resourceReaders;

    public CombiningResourceReader(ResourceReader ... resourceReaders) {
        if (resourceReaders.length == 0) {
            throw new IllegalArgumentException("at least one resourceReader has to be provided");
        }
        this.resourceReaders = resourceReaders;
    }

    @Override
    public boolean canRead(String location) {
        for (ResourceReader resourceReader : this.resourceReaders) {
            if (!resourceReader.canRead(location)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String read(String location) throws IOException {
        for (ResourceReader resourceReader : this.resourceReaders) {
            String result = resourceReader.read(location);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public byte[] readBytes(String location) throws IOException {
        for (ResourceReader resourceReader : this.resourceReaders) {
            byte[] result = resourceReader.readBytes(location);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public long lastModified(String location) {
        for (ResourceReader resourceReader : this.resourceReaders) {
            long result = resourceReader.lastModified(location);
            if (result == Long.MAX_VALUE) continue;
            return result;
        }
        return Long.MAX_VALUE;
    }
}

