/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbie.lesscss.engine;

import com.github.houbie.lesscss.engine.CommandLineLesscCompilationEngine;
import com.github.houbie.lesscss.engine.LessCompilationEngine;
import com.github.houbie.lesscss.engine.RhinoLessCompilationEngine;
import com.github.houbie.lesscss.engine.ScriptEngineLessCompilationEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LessCompilationEngineFactory {
    public static final String RHINO = "rhino";
    public static final String NASHORN = "nashorn";
    public static final String COMMAND_LINE = "commandline";
    private static Logger logger = LoggerFactory.getLogger(LessCompilationEngineFactory.class);

    public static LessCompilationEngine create() {
        logger.info("creating default Rhino less compilation engine");
        return new RhinoLessCompilationEngine();
    }

    public static LessCompilationEngine create(String type) {
        return LessCompilationEngineFactory.create(type, null);
    }

    public static LessCompilationEngine create(String type, String executable) {
        if (type == null || RHINO.equals(type)) {
            return LessCompilationEngineFactory.create();
        }
        if (COMMAND_LINE.equals(type)) {
            return new CommandLineLesscCompilationEngine(executable);
        }
        return new ScriptEngineLessCompilationEngine(type);
    }
}

