/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbie.lesscss.builder;

import com.github.houbie.lesscss.Options;
import com.github.houbie.lesscss.resourcereader.FileSystemResourceReader;
import com.github.houbie.lesscss.resourcereader.ResourceReader;
import com.github.houbie.lesscss.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class CompilationUnit
implements Serializable {
    private String sourceLocation;
    private File destination;
    private Options options;
    private File sourceMapFile;
    private ResourceReader resourceReader;
    private List<String> imports = new ArrayList<String>();
    private String encoding;
    private long exceptionTimestamp;

    public CompilationUnit(File source, File destination) {
        this(source, destination, new Options());
    }

    public CompilationUnit(File source, File destination, Options options) {
        this(source.getPath(), destination, options, new FileSystemResourceReader(source.getAbsoluteFile().getParentFile()));
    }

    public CompilationUnit(String sourceLocation, File destination, Options options, ResourceReader resourceReader) {
        this(sourceLocation, destination, options, resourceReader, new File(destination.getParentFile(), destination.getPath() + ".map"));
    }

    public CompilationUnit(String sourceLocation, File destination, Options options, ResourceReader resourceReader, File sourceMapFile) {
        if (StringUtils.isEmpty(sourceLocation) || destination == null || options == null) {
            throw new IllegalArgumentException("source, destination and options must be provided");
        }
        this.sourceLocation = sourceLocation;
        this.destination = destination;
        this.options = options;
        this.resourceReader = resourceReader;
        this.sourceMapFile = sourceMapFile;
    }

    public void setExceptionTimestamp(long timestamp) {
        this.exceptionTimestamp = timestamp;
    }

    public boolean isDirty() {
        long refTimeStamp;
        if (!this.destination.exists() && this.exceptionTimestamp == 0L) {
            return true;
        }
        long l = refTimeStamp = this.destination.exists() ? Math.max(this.destination.lastModified(), this.exceptionTimestamp) : this.exceptionTimestamp;
        if (this.resourceReader.lastModified(this.sourceLocation) > refTimeStamp) {
            return true;
        }
        if (this.imports != null) {
            for (String imported : this.imports) {
                if (this.resourceReader.lastModified(imported) <= refTimeStamp) continue;
                return true;
            }
        }
        return false;
    }

    public String getSourceLocation() {
        return this.sourceLocation;
    }

    public void setSourceLocation(String sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    public File getDestination() {
        return this.destination;
    }

    public void setDestination(File destination) {
        this.destination = destination;
    }

    public Options getOptions() {
        return this.options;
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    public ResourceReader getResourceReader() {
        return this.resourceReader;
    }

    public void setResourceReader(ResourceReader resourceReader) {
        this.resourceReader = resourceReader;
    }

    public File getSourceMapFile() {
        return this.sourceMapFile;
    }

    public void setSourceMapFile(File sourceMapFile) {
        this.sourceMapFile = sourceMapFile;
    }

    public List<String> getImports() {
        return this.imports;
    }

    protected void setImports(List<String> imports) {
        this.imports = imports;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getSourceAsString() throws IOException {
        return this.resourceReader.read(this.sourceLocation);
    }

    public boolean isEquivalent(CompilationUnit other) {
        if (!this.destination.getAbsoluteFile().equals(other.destination.getAbsoluteFile())) {
            return false;
        }
        if (this.encoding != null ? !this.encoding.equals(other.encoding) : other.encoding != null) {
            return false;
        }
        if (this.resourceReader != null ? !this.resourceReader.equals(other.resourceReader) : other.resourceReader != null) {
            return false;
        }
        if (!this.options.equals(other.options)) {
            return false;
        }
        if (this.sourceMapFile != null ? !this.sourceMapFile.equals(other.sourceMapFile) : other.sourceMapFile != null) {
            return false;
        }
        return this.sourceLocation.equals(other.sourceLocation);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompilationUnit unit = (CompilationUnit)o;
        if (!this.isEquivalent(unit)) {
            return false;
        }
        return this.imports == null ? unit.imports == null : this.imports.equals(unit.imports);
    }

    public int hashCode() {
        int result = this.sourceLocation.hashCode();
        result = 31 * result + this.destination.getAbsoluteFile().hashCode();
        result = 31 * result + this.options.hashCode();
        result = 31 * result + (this.resourceReader != null ? this.resourceReader.hashCode() : 0);
        result = 31 * result + (this.encoding != null ? this.encoding.hashCode() : 0);
        result = 31 * result + (this.sourceMapFile != null ? this.sourceMapFile.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "CompilationUnit{sourceLocation=" + this.sourceLocation + ", destination=" + this.destination + '}';
    }
}

