/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbie.lesscss.builder;

import com.github.houbie.lesscss.LessCompiler;
import com.github.houbie.lesscss.LessCompilerImpl;
import com.github.houbie.lesscss.LessParseException;
import com.github.houbie.lesscss.builder.CompilationListener;
import com.github.houbie.lesscss.builder.CompilationUnit;
import com.github.houbie.lesscss.engine.LessCompilationEngine;
import com.github.houbie.lesscss.utils.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompilationTask {
    private static final Logger logger = LoggerFactory.getLogger(CompilationTask.class);
    private File cacheDir;
    private LessCompiler lessCompiler;
    private Set<CompilationUnit> compilationUnits = new HashSet<CompilationUnit>();
    private CompilationListener compilationListener;
    private long customJavaScriptHashCode;
    protected Thread daemon;
    private boolean stopDaemon;

    public CompilationTask(LessCompilationEngine engine) throws IOException {
        this(engine, (Reader)null);
    }

    public CompilationTask(LessCompilationEngine engine, File cacheDir) throws IOException {
        this(engine, (Reader)null, cacheDir);
    }

    public CompilationTask(LessCompilationEngine engine, File customJavaScript, File cacheDir) throws IOException {
        this(engine, new FileReader(customJavaScript), cacheDir);
    }

    public CompilationTask(LessCompilationEngine engine, Reader customJavaScriptReader) throws IOException {
        this(engine, customJavaScriptReader, null);
    }

    public CompilationTask(LessCompilationEngine engine, Reader customJavaScriptReader, File cacheDir) throws IOException {
        if (customJavaScriptReader != null) {
            String customJavaScript = IOUtils.read(customJavaScriptReader);
            this.lessCompiler = new LessCompilerImpl(engine, customJavaScript);
            this.customJavaScriptHashCode = customJavaScript.hashCode();
        } else {
            this.lessCompiler = new LessCompilerImpl(engine);
        }
        this.cacheDir = cacheDir == null ? new File(new File(System.getProperty("user.home")), ".lesscss") : cacheDir;
    }

    public Collection<CompilationUnit> execute() throws IOException {
        ArrayList<CompilationUnit> compiledUnits = new ArrayList<CompilationUnit>();
        logger.debug("CompilationTask: execute");
        long start = System.currentTimeMillis();
        for (CompilationUnit unit : this.compilationUnits) {
            if (!this.compileIfDirty(unit)) continue;
            compiledUnits.add(unit);
        }
        logger.debug("execute finished in {} millis", (Object)(System.currentTimeMillis() - start));
        return compiledUnits;
    }

    public void startDaemon(final long interval) {
        if (this.daemon != null) {
            throw new RuntimeException("Trying to start daemon while it is still running");
        }
        this.stopDaemon = false;
        this.daemon = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (!CompilationTask.this.stopDaemon) {
                        try {
                            Collection<CompilationUnit> units = CompilationTask.this.execute();
                            if (!units.isEmpty() && CompilationTask.this.compilationListener != null) {
                                CompilationTask.this.compilationListener.notifySuccessfulCompilation(units);
                            }
                        }
                        catch (LessParseException e) {
                            System.out.println(e.getMessage());
                        }
                        Thread.sleep(interval);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                CompilationTask.this.daemon = null;
            }
        }, "LessCompilationDaemon");
        this.daemon.setDaemon(true);
        this.daemon.start();
    }

    public void stopDaemon() {
        this.stopDaemon = true;
    }

    private boolean compileIfDirty(CompilationUnit unit) throws IOException {
        if (this.isDirty(unit)) {
            logger.debug("compiling less: {}", (Object)unit);
            long start = System.currentTimeMillis();
            try {
                String sourceMapFileName = unit.getSourceMapFile() != null ? unit.getSourceMapFile().getPath() : null;
                LessCompiler.CompilationDetails compilationResult = this.lessCompiler.compileWithDetails(unit.getSourceAsString(), unit.getResourceReader(), unit.getOptions(), unit.getSourceLocation(), unit.getDestination().getPath(), sourceMapFileName);
                if (unit.getDestination() != null) {
                    unit.getDestination().getAbsoluteFile().getParentFile().mkdirs();
                    IOUtils.writeFile(compilationResult.getResult(), unit.getDestination(), unit.getEncoding());
                }
                if (unit.getSourceMapFile() != null && compilationResult.getSourceMap() != null) {
                    unit.getSourceMapFile().getAbsoluteFile().getParentFile().mkdirs();
                    IOUtils.writeFile(compilationResult.getSourceMap(), unit.getSourceMapFile(), unit.getEncoding());
                }
                this.updateImportsAndCache(unit, compilationResult.getImports());
                logger.info("compilation of less {} finished in {} millis", (Object)unit, (Object)(System.currentTimeMillis() - start));
                return true;
            }
            catch (LessParseException e) {
                unit.setExceptionTimestamp(System.currentTimeMillis());
                this.cache(unit);
                throw e;
            }
        }
        return false;
    }

    private boolean isDirty(CompilationUnit unit) {
        CompilationUnit cachedUnit = this.readFromCache(unit);
        return cachedUnit == null || !unit.isEquivalent(cachedUnit) || cachedUnit.isDirty();
    }

    protected CompilationUnit readFromCache(CompilationUnit unit) {
        File cacheFile = this.getCacheFile(unit);
        if (cacheFile.canRead()) {
            try {
                return (CompilationUnit)new ObjectInputStream(new FileInputStream(cacheFile)).readObject();
            }
            catch (Exception e) {
                logger.warn("Could not read cached compilationUnit", (Throwable)e);
            }
        }
        return null;
    }

    private void updateImportsAndCache(CompilationUnit unit, List<String> imports) throws IOException {
        unit.setImports(imports);
        this.cache(unit);
    }

    private File getCacheFile(CompilationUnit unit) {
        File dir = new File(this.cacheDir, Long.toHexString(this.customJavaScriptHashCode));
        return new File(dir, Long.toHexString(unit.hashCode()));
    }

    private void cache(CompilationUnit unit) {
        try {
            File file = this.getCacheFile(unit);
            file.getParentFile().mkdirs();
            ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(file));
            os.writeObject(unit);
            os.flush();
            os.close();
        }
        catch (IOException e) {
            logger.error("Could not cache compilationUnit", (Throwable)e);
        }
    }

    public File getCacheDir() {
        return this.cacheDir;
    }

    public void setCacheDir(File cacheDir) {
        this.cacheDir = cacheDir;
    }

    public LessCompiler getLessCompiler() {
        return this.lessCompiler;
    }

    protected void setLessCompiler(LessCompiler lessCompiler) {
        this.lessCompiler = lessCompiler;
    }

    public Set<CompilationUnit> getCompilationUnits() {
        return this.compilationUnits;
    }

    public void setCompilationUnits(Set<CompilationUnit> compilationUnits) {
        this.compilationUnits = compilationUnits;
    }

    public CompilationListener getCompilationListener() {
        return this.compilationListener;
    }

    public void setCompilationListener(CompilationListener compilationListener) {
        this.compilationListener = compilationListener;
    }
}

