/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbie.lesscss;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Options
implements Serializable {
    private boolean compress = false;
    private int optimizationLevel = 1;
    private boolean strictImports = false;
    private String rootpath;
    private boolean relativeUrls = false;
    private LineNumbersOutput dumpLineNumbers = LineNumbersOutput.NONE;
    private boolean minify = false;
    private boolean dependenciesOnly = false;
    private boolean strictMath = false;
    private boolean strictUnits = false;
    private boolean ieCompat = true;
    private boolean javascriptEnabled = true;
    private boolean lint = false;
    private boolean silent = false;
    private boolean sourceMap = false;
    private String sourceMapRootpath;
    private String sourceMapBasepath;
    private boolean sourceMapLessInline;
    private boolean sourceMapMapInline;
    private String sourceMapURL;
    private Map<String, String> globalVars = new HashMap<String, String>();
    private Map<String, String> modifyVars = new HashMap<String, String>();

    public Options() {
    }

    public Options(Options other) {
        this.compress = other.compress;
        this.optimizationLevel = other.optimizationLevel;
        this.strictImports = other.strictImports;
        this.rootpath = other.rootpath;
        this.relativeUrls = other.relativeUrls;
        this.dumpLineNumbers = other.dumpLineNumbers;
        this.minify = other.minify;
        this.dependenciesOnly = other.dependenciesOnly;
        this.strictMath = other.strictMath;
        this.strictUnits = other.strictUnits;
        this.ieCompat = other.ieCompat;
        this.javascriptEnabled = other.javascriptEnabled;
        this.lint = other.lint;
        this.silent = other.silent;
        this.sourceMap = other.sourceMap;
        this.sourceMapRootpath = other.sourceMapRootpath;
        this.sourceMapBasepath = other.sourceMapBasepath;
        this.sourceMapLessInline = other.sourceMapLessInline;
        this.sourceMapMapInline = other.sourceMapMapInline;
        this.sourceMapURL = other.sourceMapURL;
        this.globalVars = other.globalVars;
        this.modifyVars = other.modifyVars;
    }

    public boolean isCompress() {
        return this.compress;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public int getOptimizationLevel() {
        return this.optimizationLevel;
    }

    public void setOptimizationLevel(int optimizationLevel) {
        this.optimizationLevel = optimizationLevel;
    }

    public boolean isStrictImports() {
        return this.strictImports;
    }

    public void setStrictImports(boolean strictImports) {
        this.strictImports = strictImports;
    }

    public String getRootpath() {
        return this.rootpath;
    }

    public void setRootpath(String rootpath) {
        this.rootpath = rootpath;
    }

    public boolean isRelativeUrls() {
        return this.relativeUrls;
    }

    public void setRelativeUrls(boolean relativeUrls) {
        this.relativeUrls = relativeUrls;
    }

    public LineNumbersOutput getDumpLineNumbers() {
        return this.dumpLineNumbers;
    }

    public void setDumpLineNumbers(LineNumbersOutput dumpLineNumbers) {
        if (dumpLineNumbers == null) {
            throw new NullPointerException("Options.dumpLineNumbers may not be null");
        }
        this.dumpLineNumbers = dumpLineNumbers;
    }

    public boolean isMinify() {
        return this.minify;
    }

    public void setMinify(boolean minify) {
        this.minify = minify;
    }

    public boolean isDependenciesOnly() {
        return this.dependenciesOnly;
    }

    public void setDependenciesOnly(boolean dependenciesOnly) {
        this.dependenciesOnly = dependenciesOnly;
    }

    public boolean isStrictMath() {
        return this.strictMath;
    }

    public void setStrictMath(boolean strictMath) {
        this.strictMath = strictMath;
    }

    public boolean isStrictUnits() {
        return this.strictUnits;
    }

    public void setStrictUnits(boolean strictUnits) {
        this.strictUnits = strictUnits;
    }

    public boolean isIeCompat() {
        return this.ieCompat;
    }

    public void setIeCompat(boolean ieCompat) {
        this.ieCompat = ieCompat;
    }

    public boolean isJavascriptEnabled() {
        return this.javascriptEnabled;
    }

    public void setJavascriptEnabled(boolean javascriptEnabled) {
        this.javascriptEnabled = javascriptEnabled;
    }

    public boolean isLint() {
        return this.lint;
    }

    public void setLint(boolean lint) {
        this.lint = lint;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public boolean isSourceMap() {
        return this.sourceMap;
    }

    public void setSourceMap(boolean sourceMap) {
        this.sourceMap = sourceMap;
    }

    public String getSourceMapRootpath() {
        return this.sourceMapRootpath;
    }

    public void setSourceMapRootpath(String sourceMapRootpath) {
        this.sourceMapRootpath = sourceMapRootpath;
    }

    public String getSourceMapBasepath() {
        return this.sourceMapBasepath;
    }

    public void setSourceMapBasepath(String sourceMapBasepath) {
        this.sourceMapBasepath = sourceMapBasepath;
    }

    public boolean isSourceMapLessInline() {
        return this.sourceMapLessInline;
    }

    public void setSourceMapLessInline(boolean sourceMapLessInline) {
        this.sourceMapLessInline = sourceMapLessInline;
    }

    public boolean isSourceMapMapInline() {
        return this.sourceMapMapInline;
    }

    public void setSourceMapMapInline(boolean sourceMapMapInline) {
        this.sourceMapMapInline = sourceMapMapInline;
    }

    public String getSourceMapURL() {
        return this.sourceMapURL;
    }

    public void setSourceMapURL(String sourceMapURL) {
        this.sourceMapURL = sourceMapURL;
    }

    public Map<String, String> getGlobalVars() {
        return this.globalVars;
    }

    public void setGlobalVars(Map<String, String> globalVars) {
        this.globalVars = globalVars;
    }

    public Map<String, String> getModifyVars() {
        return this.modifyVars;
    }

    public void setModifyVars(Map<String, String> modifyVars) {
        this.modifyVars = modifyVars;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Options options = (Options)o;
        if (this.minify != options.minify) {
            return false;
        }
        if (this.compress != options.compress) {
            return false;
        }
        if (this.dependenciesOnly != options.dependenciesOnly) {
            return false;
        }
        if (this.ieCompat != options.ieCompat) {
            return false;
        }
        if (this.javascriptEnabled != options.javascriptEnabled) {
            return false;
        }
        if (this.lint != options.lint) {
            return false;
        }
        if (this.optimizationLevel != options.optimizationLevel) {
            return false;
        }
        if (this.relativeUrls != options.relativeUrls) {
            return false;
        }
        if (this.silent != options.silent) {
            return false;
        }
        if (this.sourceMap != options.sourceMap) {
            return false;
        }
        if (this.sourceMapLessInline != options.sourceMapLessInline) {
            return false;
        }
        if (this.sourceMapMapInline != options.sourceMapMapInline) {
            return false;
        }
        if (this.strictImports != options.strictImports) {
            return false;
        }
        if (this.strictMath != options.strictMath) {
            return false;
        }
        if (this.strictUnits != options.strictUnits) {
            return false;
        }
        if (this.dumpLineNumbers != options.dumpLineNumbers) {
            return false;
        }
        if (!this.globalVars.equals(options.globalVars)) {
            return false;
        }
        if (!this.modifyVars.equals(options.modifyVars)) {
            return false;
        }
        if (this.rootpath != null ? !this.rootpath.equals(options.rootpath) : options.rootpath != null) {
            return false;
        }
        if (this.sourceMapBasepath != null ? !this.sourceMapBasepath.equals(options.sourceMapBasepath) : options.sourceMapBasepath != null) {
            return false;
        }
        if (this.sourceMapRootpath != null ? !this.sourceMapRootpath.equals(options.sourceMapRootpath) : options.sourceMapRootpath != null) {
            return false;
        }
        return !(this.sourceMapURL != null ? !this.sourceMapURL.equals(options.sourceMapURL) : options.sourceMapURL != null);
    }

    public int hashCode() {
        int result = this.compress ? 1 : 0;
        result = 31 * result + this.optimizationLevel;
        result = 31 * result + (this.strictImports ? 1 : 0);
        result = 31 * result + (this.rootpath != null ? this.rootpath.hashCode() : 0);
        result = 31 * result + (this.relativeUrls ? 1 : 0);
        result = 31 * result + this.dumpLineNumbers.hashCode();
        result = 31 * result + (this.minify ? 1 : 0);
        result = 31 * result + (this.dependenciesOnly ? 1 : 0);
        result = 31 * result + (this.strictMath ? 1 : 0);
        result = 31 * result + (this.strictUnits ? 1 : 0);
        result = 31 * result + (this.ieCompat ? 1 : 0);
        result = 31 * result + (this.javascriptEnabled ? 1 : 0);
        result = 31 * result + (this.lint ? 1 : 0);
        result = 31 * result + (this.silent ? 1 : 0);
        result = 31 * result + (this.sourceMap ? 1 : 0);
        result = 31 * result + (this.sourceMapRootpath != null ? this.sourceMapRootpath.hashCode() : 0);
        result = 31 * result + (this.sourceMapBasepath != null ? this.sourceMapBasepath.hashCode() : 0);
        result = 31 * result + (this.sourceMapLessInline ? 1 : 0);
        result = 31 * result + (this.sourceMapMapInline ? 1 : 0);
        result = 31 * result + (this.sourceMapURL != null ? this.sourceMapURL.hashCode() : 0);
        result = 31 * result + this.globalVars.hashCode();
        result = 31 * result + this.modifyVars.hashCode();
        return result;
    }

    public static enum LineNumbersOutput {
        NONE(null),
        COMMENTS("comments"),
        MEDIA_QUERY("mediaquery"),
        ALL("all");

        private final String optionString;

        private LineNumbersOutput(String optionString) {
            this.optionString = optionString;
        }

        public String getOptionString() {
            return this.optionString;
        }

        public static LineNumbersOutput fromOptionString(String optionString) {
            if (optionString == null || optionString.trim().length() == 0) {
                return NONE;
            }
            if (COMMENTS.getOptionString().equals(optionString)) {
                return COMMENTS;
            }
            if (MEDIA_QUERY.getOptionString().equals(optionString)) {
                return MEDIA_QUERY;
            }
            if (ALL.getOptionString().equals(optionString)) {
                return ALL;
            }
            throw new RuntimeException("Invalid line numbers type: " + optionString);
        }
    }
}

