/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbie.lesscss;

import com.github.houbie.lesscss.LessCompiler;
import com.github.houbie.lesscss.LessCompilerImpl;
import com.github.houbie.lesscss.LesscCommandLineParser;
import com.github.houbie.lesscss.builder.CompilationTask;
import com.github.houbie.lesscss.builder.CompilationUnit;
import com.github.houbie.lesscss.engine.LessCompilationEngine;
import com.github.houbie.lesscss.engine.LessCompilationEngineFactory;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.cli.ParseException;

public class Lessc {
    public static final String LESS_VERSION = "1.7.0";
    protected static InputStream systemIn = System.in;

    public static void main(String[] args) throws Exception {
        LesscCommandLineParser lesscCommandLineParser = new LesscCommandLineParser(Lessc.getVersionInfo());
        try {
            boolean done = lesscCommandLineParser.parse(args);
            if (!done) {
                Lessc.execute(lesscCommandLineParser);
            }
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            LesscCommandLineParser.printHelp();
        }
    }

    private static void execute(LesscCommandLineParser cmd) throws Exception {
        try {
            if (cmd.getOptions().isDependenciesOnly()) {
                Lessc.printDependencies(cmd);
            } else if (cmd.getDestination() == null) {
                Lessc.printCompilationResult(cmd);
            } else {
                Lessc.compileToDestination(cmd);
            }
        }
        catch (Exception e) {
            if (cmd.isVerbose()) {
                throw e;
            }
            System.err.println(e.getMessage());
        }
    }

    private static void printDependencies(LesscCommandLineParser cmd) throws IOException {
        LessCompiler.CompilationDetails compilationDetails = Lessc.compileWithDetails(cmd);
        System.out.println("Dependencies for " + cmd.getSourceLocation() + ":");
        for (String importPath : compilationDetails.getImports()) {
            System.out.println(importPath);
        }
    }

    private static void printCompilationResult(LesscCommandLineParser cmd) throws IOException {
        LessCompiler.CompilationDetails compilationDetails = Lessc.compileWithDetails(cmd);
        System.out.println(compilationDetails.getResult());
    }

    private static LessCompiler.CompilationDetails compileWithDetails(LesscCommandLineParser cmd) throws IOException {
        LessCompilationEngine engine = LessCompilationEngineFactory.create(cmd.getEngine());
        LessCompilerImpl lessCompiler = new LessCompilerImpl(engine, cmd.getCustomJsReader());
        return lessCompiler.compileWithDetails(cmd.getResourceReader().read(cmd.getSourceLocation()), cmd.getResourceReader(), cmd.getOptions(), cmd.getSourceLocation());
    }

    private static void compileToDestination(LesscCommandLineParser cmd) throws IOException {
        LessCompilationEngine engine = LessCompilationEngineFactory.create(cmd.getEngine());
        CompilationTask compilationTask = new CompilationTask(engine, cmd.getCustomJsReader(), cmd.getCacheDir());
        CompilationUnit compilationUnit = new CompilationUnit(cmd.getSourceLocation(), cmd.getDestination(), cmd.getOptions(), cmd.getResourceReader(), cmd.getSourceMapFile());
        compilationTask.getCompilationUnits().add(compilationUnit);
        if (cmd.isDaemon()) {
            Lessc.runDaemon(compilationTask);
        } else {
            compilationTask.execute();
        }
    }

    private static void runDaemon(CompilationTask compilationTask) throws IOException {
        compilationTask.startDaemon(500L);
        System.out.println("Compiler daemon running, press q to quit...");
        while (systemIn.read() != 113) {
        }
        compilationTask.stopDaemon();
    }

    private static String getVersionInfo() {
        String version = LessCompiler.class.getPackage().getImplementationVersion();
        return "LessCompiler version " + version + ", using Less version " + LESS_VERSION;
    }
}

