/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbie.lesscss;

import com.github.houbie.lesscss.LessCompiler;
import com.github.houbie.lesscss.Options;
import com.github.houbie.lesscss.engine.CompilationOptions;
import com.github.houbie.lesscss.engine.LessCompilationEngine;
import com.github.houbie.lesscss.resourcereader.FileSystemResourceReader;
import com.github.houbie.lesscss.resourcereader.ResourceReader;
import com.github.houbie.lesscss.resourcereader.TrackingResourceReader;
import com.github.houbie.lesscss.utils.IOUtils;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LessCompilerImpl
implements LessCompiler {
    private static final String UNKNOWN_SOURCE_NAME = "unknown";
    private static final Logger logger = LoggerFactory.getLogger(LessCompilerImpl.class);
    private final LessCompilationEngine engine;

    public LessCompilerImpl(LessCompilationEngine engine) {
        this(engine, (Reader)null);
    }

    public LessCompilerImpl(LessCompilationEngine engine, String customJavaScript) {
        this(engine, new StringReader(customJavaScript));
    }

    public LessCompilerImpl(LessCompilationEngine engine, Reader customJavaScriptReader) {
        this.engine = engine;
        engine.initialize(customJavaScriptReader);
    }

    @Override
    public String compile(File source) throws IOException {
        return this.compile(source, new Options());
    }

    @Override
    public String compile(File source, Options options) throws IOException {
        if (source == null) {
            throw new NullPointerException("less file may not be null");
        }
        return this.compile(IOUtils.read(source), new FileSystemResourceReader(source.getAbsoluteFile().getParentFile()), options, source.getPath());
    }

    @Override
    public void compile(File source, File destination) throws IOException {
        this.compile(source, destination, new Options(), new FileSystemResourceReader(source.getAbsoluteFile().getParentFile()), null);
    }

    @Override
    public void compile(File source, File destination, Options options, ResourceReader importReader, String encoding) throws IOException {
        if (source == null) {
            throw new NullPointerException("less file may not be null");
        }
        LessCompiler.CompilationDetails details = this.compileWithDetails(IOUtils.read(source, encoding), importReader, options, source.getPath(), destination.getPath(), this.getSourceMapFileName(source.getPath()));
        IOUtils.writeFile(details.getResult(), destination, encoding);
    }

    @Override
    public String compile(String less) {
        return this.compile(less, null, UNKNOWN_SOURCE_NAME);
    }

    @Override
    public String compile(String less, ResourceReader importReader, String sourceFilename) {
        return this.compile(less, importReader, new Options(), sourceFilename);
    }

    @Override
    public String compile(String less, ResourceReader importReader, Options options, String sourceFilename) {
        return this.compileWithDetails(less, importReader, options, sourceFilename, this.getDestinationFileName(sourceFilename), this.getSourceMapFileName(sourceFilename)).getResult();
    }

    @Override
    public String compile(String less, ResourceReader importReader, Options options, String sourceFilename, String destinationFilename, String sourceMapFilename) {
        return this.compileWithDetails(less, importReader, options, sourceFilename, destinationFilename, sourceMapFilename).getResult();
    }

    @Override
    public LessCompiler.CompilationDetails compileWithDetails(String less, ResourceReader importReader, Options options, String sourceFilename) {
        return this.compileWithDetails(less, importReader, options, sourceFilename, this.getDestinationFileName(sourceFilename), this.getSourceMapFileName(sourceFilename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LessCompiler.CompilationDetails compileWithDetails(String less, ResourceReader importReader, Options options, String sourceFilename, String destinationFilename, String sourceMapFilename) {
        LessCompiler.CompilationDetails result;
        if (less == null) {
            throw new NullPointerException("less string may not be null");
        }
        logger.debug("start less compilation");
        TrackingResourceReader trackingResourceReader = new TrackingResourceReader(importReader);
        CompilationOptions compilationOptions = new CompilationOptions(options, sourceFilename, destinationFilename, sourceMapFilename);
        LessCompilationEngine lessCompilationEngine = this.engine;
        synchronized (lessCompilationEngine) {
            result = this.engine.compile(less, compilationOptions, trackingResourceReader);
        }
        result.setImports(trackingResourceReader.getReadResources());
        logger.debug("finished less compilation");
        return result;
    }

    private String getSourceMapFileName(String sourceFilename) {
        return sourceFilename + ".map";
    }

    private String getDestinationFileName(String sourceFilename) {
        String destinationFilename = sourceFilename != null ? sourceFilename : UNKNOWN_SOURCE_NAME;
        return destinationFilename.replace(".less", ".css");
    }
}

