package com.github.houbb.rank.core;

import com.github.houbb.rank.api.IRank;
import com.github.houbb.rank.api.RankContext;

/**
 * 权重相加
 *
 * @author binbin.hou
 * @since 1.0.0
 */
public class RankWeightAdd implements IRank {

    @Override
    public double rank(RankContext context) {
        double rank = 0.0;
        //1000 阅读 10 赞 5 收藏 评论 1
        rank += context.readCount();
        rank += context.collectCount() * 500;
        rank += context.commentCount() * 500;
        rank += context.likeCount() * 100;

        // 避免使用乘法，避免过分放大
        double rate = (context.starRate() + context.avgReadSeconds() / 30.0) / 2;

        return rank * rate;
    }

}
