package com.github.houbb.rank.api;

/**
 * @author binbin.hou
 * @since 1.0.0
 */
public class RankContext {

    public static RankContext newInstance() {
        return new RankContext();
    }

    /**
     * 时间
     */
    private long unixTime;

    /**
     * 阅读数
     */
    private long readCount;
    /**
     * 评论数
     */
    private long commentCount;
    /**
     * 点赞数
     */
    private long likeCount;

    /**
     * 收藏数
     */
    private long collectCount;

    /**
     * 平均阅读秒
     */
    private long avgReadSeconds;

    /**
     * 评分
     *
     * 注意： 评分的数量一般是较少的资源。
     *
     * @since 1.0.0
     */
    private double starRate;


    public long unixTime() {
        return unixTime;
    }

    public RankContext unixTime(long unixTime) {
        this.unixTime = unixTime;
        return this;
    }

    public long readCount() {
        return readCount;
    }

    public RankContext readCount(long readCount) {
        this.readCount = readCount;
        return this;
    }

    public long commentCount() {
        return commentCount;
    }

    public RankContext commentCount(long commentCount) {
        this.commentCount = commentCount;
        return this;
    }

    public long likeCount() {
        return likeCount;
    }

    public RankContext likeCount(long likeCount) {
        this.likeCount = likeCount;
        return this;
    }

    public long collectCount() {
        return collectCount;
    }

    public RankContext collectCount(long collectCount) {
        this.collectCount = collectCount;
        return this;
    }

    public long avgReadSeconds() {
        return avgReadSeconds;
    }

    public RankContext avgReadSeconds(long avgReadSeconds) {
        this.avgReadSeconds = avgReadSeconds;
        return this;
    }

    public double starRate() {
        return starRate;
    }

    public RankContext starRate(double starRate) {
        this.starRate = starRate;
        return this;
    }

    @Override
    public String toString() {
        return "RankContext{" +
                "unixTime=" + unixTime +
                ", readCount=" + readCount +
                ", commentCount=" + commentCount +
                ", likeCount=" + likeCount +
                ", collectCount=" + collectCount +
                ", avgReadSeconds=" + avgReadSeconds +
                ", starRate=" + starRate +
                '}';
    }

}
