/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.opencc4j.util;

import com.github.houbb.paradise.common.util.ObjectUtil;
import com.github.houbb.paradise.common.util.StringUtil;
import com.huaban.analysis.jieba.JiebaSegmenter;
import java.util.Collections;
import java.util.List;

public final class FenciUtil {
    private static final ThreadLocal<JiebaSegmenter> THREAD_LOCAL = new ThreadLocal();

    private FenciUtil() {
    }

    public static List<String> huaban(String original) {
        try {
            if (StringUtil.isEmpty((String)original)) {
                List<String> list = Collections.emptyList();
                return list;
            }
            JiebaSegmenter segmenter = FenciUtil.getJiebaSegmenter();
            List list = segmenter.sentenceProcess(original);
            return list;
        }
        finally {
            THREAD_LOCAL.remove();
        }
    }

    private static JiebaSegmenter getJiebaSegmenter() {
        JiebaSegmenter segmenter = THREAD_LOCAL.get();
        if (ObjectUtil.isNull((Object)segmenter).booleanValue()) {
            segmenter = new JiebaSegmenter();
            THREAD_LOCAL.set(segmenter);
        }
        return segmenter;
    }
}

