/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.util.util;

import com.github.houbb.heaven.support.condition.ICondition;
import com.github.houbb.heaven.support.filter.IFilter;
import com.github.houbb.heaven.support.handler.IHandler;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class CollectionUtil {
    public static final List EMPTY_LIST = Collections.emptyList();

    private CollectionUtil() {
    }

    public static boolean isEmpty(Collection collection) {
        return null == collection || collection.isEmpty();
    }

    public static boolean isNotEmpty(Collection collection) {
        return !CollectionUtil.isEmpty(collection);
    }

    public static List<String> arrayToList(String[] array) {
        if (ArrayUtil.isEmpty(array)) {
            return Collections.emptyList();
        }
        return Arrays.asList(array);
    }

    public static String[] listToArray(List<String> stringList) {
        String[] strings = new String[stringList.size()];
        return stringList.toArray(strings);
    }

    public static Collection<String> trimCollection(Collection<String> stringList) {
        if (CollectionUtil.isEmpty(stringList)) {
            return Collections.emptyList();
        }
        ArrayList<String> resultList = new ArrayList<String>();
        for (String original : stringList) {
            resultList.add(original.trim());
        }
        return resultList;
    }

    public static <T, R> Collection<R> buildCollection(Collection<T> targets, IHandler<T, R> handler) {
        if (CollectionUtil.isEmpty(targets)) {
            return Collections.emptyList();
        }
        ArrayList<R> rList = new ArrayList<R>();
        for (T t : targets) {
            R r = handler.handle(t);
            if (!ObjectUtil.isNotNull(r)) continue;
            rList.add(r);
        }
        return rList;
    }

    public static <T, R> Collection<R> buildCollection(T[] targets, IHandler<T, R> handler) {
        if (ArrayUtil.isEmpty(targets)) {
            return Collections.emptyList();
        }
        ArrayList<R> rList = new ArrayList<R>();
        for (T t : targets) {
            R r = handler.handle(t);
            if (!ObjectUtil.isNotNull(r)) continue;
            rList.add(r);
        }
        return rList;
    }

    public static <T> void addArray(Collection<T> collection, T[] array) {
        if (ArrayUtil.isEmpty(array)) {
            return;
        }
        collection.addAll(Arrays.asList(array));
    }

    public static <K, V> List<K> toList(Iterable<V> values, IHandler<? super V, K> keyFunction) {
        if (ObjectUtil.isNull(values)) {
            return Collections.emptyList();
        }
        return CollectionUtil.toList(values.iterator(), keyFunction);
    }

    public static <K, V> List<K> toList(Iterator<V> values, IHandler<? super V, K> keyFunction) {
        if (ObjectUtil.isNull(values)) {
            return Collections.emptyList();
        }
        ArrayList<K> list = new ArrayList<K>();
        while (values.hasNext()) {
            V value = values.next();
            K key = keyFunction.handle(value);
            list.add(key);
        }
        return list;
    }

    public static List<String> splitByAnyBlank(String string) {
        if (StringUtil.isEmpty(string)) {
            return Collections.emptyList();
        }
        String pattern = "\\s+";
        String[] strings = string.split(pattern);
        return new ArrayList<String>(Arrays.asList(strings));
    }

    public static <T> List<T> filterList(List<T> list, IFilter<T> filter) {
        if (CollectionUtil.isEmpty(list)) {
            return Collections.emptyList();
        }
        ArrayList<T> resultList = new ArrayList<T>();
        for (T t : list) {
            if (filter.filter(t)) continue;
            resultList.add(t);
        }
        return resultList;
    }

    public static <T> List<T> conditionList(List<T> list, ICondition<T> condition) {
        if (CollectionUtil.isEmpty(list)) {
            return Collections.emptyList();
        }
        ArrayList<T> resultList = new ArrayList<T>();
        for (T t : list) {
            if (!condition.condition(t)) continue;
            resultList.add(t);
        }
        return resultList;
    }

    public static List<String> toStringList(List<?> pathList) {
        if (CollectionUtil.isEmpty(pathList)) {
            return Collections.emptyList();
        }
        ArrayList<String> stringList = new ArrayList<String>(pathList.size());
        for (Object object : pathList) {
            if (!ObjectUtil.isNotNull(object)) continue;
            stringList.add(object.toString());
        }
        return stringList;
    }
}

