/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.util.lang;

import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.lang.reflect.ClassTypeUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import com.github.houbb.heaven.util.util.MapUtil;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public final class ObjectUtil {
    private ObjectUtil() {
    }

    public static boolean isSameType(Object one, Object two) {
        if (ObjectUtil.isNull(one) || ObjectUtil.isNull(two)) {
            return false;
        }
        Class<?> clazzOne = one.getClass();
        return clazzOne.isInstance(two);
    }

    public static boolean isNotSameType(Object one, Object two) {
        return !ObjectUtil.isSameType(one, two);
    }

    public static boolean isNull(Object object) {
        return null == object;
    }

    public static boolean isNotNull(Object object) {
        return !ObjectUtil.isNull(object);
    }

    public static boolean isEmpty(Object object) {
        if (ObjectUtil.isNull(object)) {
            return true;
        }
        if (object instanceof String) {
            String string = (String)object;
            return StringUtil.isEmpty(string);
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            return CollectionUtil.isEmpty(collection);
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return MapUtil.isEmpty(map);
        }
        if (object.getClass().isArray()) {
            return Array.getLength(object) == 0;
        }
        return false;
    }

    public static boolean isNotEmpty(Object object) {
        return !ObjectUtil.isEmpty(object);
    }

    public static boolean isEquals(Object except, Object real) {
        if (ObjectUtil.isNotSameType(except, real)) {
            return false;
        }
        Class<?> exceptClass = except.getClass();
        Class<?> realClass = except.getClass();
        if (exceptClass.isPrimitive() && realClass.isPrimitive() && except != real) {
            return false;
        }
        if (ClassTypeUtil.isArray(exceptClass) && ClassTypeUtil.isArray(realClass)) {
            Object[] exceptArray = (Object[])except;
            Object[] realArray = (Object[])real;
            return Arrays.equals(exceptArray, realArray);
        }
        if (ClassTypeUtil.isMap(exceptClass) && ClassTypeUtil.isMap(realClass)) {
            Map exceptMap = (Map)except;
            Map realMap = (Map)real;
            return exceptMap.equals(realMap);
        }
        return except.equals(real);
    }

    public static boolean isNotEquals(Object except, Object real) {
        return !ObjectUtil.isEquals(except, real);
    }
}

