/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.compress.bs;

import com.github.houbb.compress.api.ICompressContext;
import com.github.houbb.compress.constant.enums.CompressTypeEnum;
import com.github.houbb.compress.exception.CompressRuntimeException;
import com.github.houbb.heaven.annotation.NotThreadSafe;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.util.ArrayUtil;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

@NotThreadSafe
public class CompressContextBs
implements ICompressContext {
    private List<Path> compressSources = new ArrayList<Path>();
    private Path targetPath;
    private String password = null;
    private boolean relativePath = true;
    private CompressTypeEnum compressType = CompressTypeEnum.ZIP;
    private InputStream uncompressStream;
    private boolean createFile;

    private CompressContextBs() {
    }

    public static CompressContextBs newInstance() {
        return new CompressContextBs();
    }

    public CompressContextBs compressSources(String ... sourcePaths) {
        this.innerCompressSources(sourcePaths);
        return this;
    }

    public CompressContextBs target(String targetPath) {
        if (StringUtil.isEmpty((String)targetPath)) {
            throw new CompressRuntimeException("Target path not allow empty!");
        }
        this.targetPath = Paths.get(targetPath, new String[0]);
        return this;
    }

    public CompressContextBs relativePath(boolean isRelativePath) {
        this.relativePath = isRelativePath;
        return this;
    }

    public CompressContextBs password(String password) {
        this.password = password;
        return this;
    }

    @Override
    public InputStream uncompressStream() {
        return this.uncompressStream;
    }

    public CompressContextBs uncompressStream(InputStream uncompressStream) {
        this.uncompressStream = uncompressStream;
        return this;
    }

    @Override
    public List<Path> compressSources() {
        return this.compressSources;
    }

    @Override
    public Path targetPath() {
        return this.targetPath;
    }

    @Override
    public String password() {
        return this.password;
    }

    @Override
    public boolean relativePath() {
        return this.relativePath;
    }

    @Override
    public CompressTypeEnum compressType() {
        return this.compressType;
    }

    public CompressContextBs compressType(CompressTypeEnum compressType) {
        this.compressType = compressType;
        return this;
    }

    private CompressContextBs innerCompressSources(String ... sourcePaths) {
        if (ArrayUtil.isEmpty((Object[])sourcePaths)) {
            throw new CompressRuntimeException("Source paths not allow empty!");
        }
        for (String source : sourcePaths) {
            this.compressSources.add(Paths.get(source, new String[0]));
        }
        return this;
    }

    @Override
    public boolean createFile() {
        return this.createFile;
    }

    public CompressContextBs createFile(boolean createFile) {
        this.createFile = createFile;
        return this;
    }
}

