/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.compress.util;

import com.github.houbb.compress.bs.CompressBs;
import com.github.houbb.compress.constant.enums.CompressTypeEnum;
import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.heaven.util.io.FileUtil;

public final class CompressHelper {
    private CompressHelper() {
    }

    public static void compress(String source) {
        String target = FileUtil.getDirPath((String)source) + FileUtil.getFileName((String)source) + "." + CompressTypeEnum.ZIP.fileSuffix();
        CompressHelper.compress(CompressTypeEnum.ZIP, source, target);
    }

    public static void compress(String source, String target) {
        String fileSuffix = FileUtil.getSuffix((String)target);
        CompressTypeEnum compressTypeEnum = CompressTypeEnum.of(fileSuffix);
        CompressHelper.compress(compressTypeEnum, source, target);
    }

    public static void compress(CompressTypeEnum compressTypeEnum, String source, String target) {
        ArgUtil.notNull((Object)((Object)compressTypeEnum), (String)"compressTypeEnum");
        ArgUtil.notEmpty((String)source, (String)"source");
        ArgUtil.notEmpty((String)target, (String)"target");
        CompressBs.newInstance(compressTypeEnum).source(source).target(target).compress();
    }

    public static void uncompress(CompressTypeEnum compressTypeEnum, String source, String targetDir) {
        ArgUtil.notNull((Object)((Object)compressTypeEnum), (String)"compressTypeEnum");
        ArgUtil.notEmpty((String)source, (String)"source");
        ArgUtil.notEmpty((String)targetDir, (String)"target");
        CompressBs.newInstance(compressTypeEnum).source(source).target(targetDir).uncompress();
    }

    public static void uncompress(String source, String targetDir) {
        String fileSuffix = FileUtil.getSuffix((String)source);
        CompressTypeEnum compressTypeEnum = CompressTypeEnum.of(fileSuffix);
        CompressHelper.uncompress(compressTypeEnum, source, targetDir);
    }

    public static void uncompress(String source) {
        String targetDir = FileUtil.getDirPath((String)source);
        CompressHelper.uncompress(source, targetDir);
    }
}

