/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.compress.api.impl;

import com.github.houbb.compress.api.ICompressContext;
import com.github.houbb.compress.constant.enums.CompressTypeEnum;
import com.github.houbb.heaven.annotation.NotThreadSafe;
import com.github.houbb.heaven.util.util.CollectionUtil;
import java.nio.file.Path;
import java.util.List;

@NotThreadSafe
public class CompressContext
implements ICompressContext {
    private boolean isRelativePath;
    private List<Path> sourcePaths;
    private Path targetPath;
    private String password;
    private CompressTypeEnum compressType;

    public static CompressContext newInstance() {
        return new CompressContext();
    }

    @Override
    public boolean isRelativePath() {
        return this.isRelativePath;
    }

    public CompressContext isRelativePath(boolean relativePath) {
        this.isRelativePath = relativePath;
        return this;
    }

    public CompressContext sourcePaths(List<Path> sourcePaths) {
        this.sourcePaths = sourcePaths;
        return this;
    }

    @Override
    public List<Path> sourcePaths() {
        return this.sourcePaths;
    }

    @Override
    public Path sourcePathFirst() {
        if (CollectionUtil.isEmpty(this.sourcePaths)) {
            return null;
        }
        return this.sourcePaths.get(0);
    }

    public CompressContext targetPath(Path targetPath) {
        this.targetPath = targetPath;
        return this;
    }

    @Override
    public Path targetPath() {
        return this.targetPath;
    }

    public CompressContext password(String password) {
        this.password = password;
        return this;
    }

    @Override
    public String password() {
        return this.password;
    }

    @Override
    public CompressTypeEnum compressType() {
        return this.compressType;
    }

    public CompressContext compressType(CompressTypeEnum compressType) {
        this.compressType = compressType;
        return this;
    }
}

