/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.swing;

import java.util.Arrays;
import smile.plot.swing.Graphics;
import smile.plot.swing.Label;
import smile.plot.swing.Plot;

public class TextPlot
extends Plot {
    final Label[] texts;

    public TextPlot(Label ... texts) {
        this.texts = texts;
    }

    @Override
    public void paint(Graphics g) {
        for (Label text : this.texts) {
            text.paint(g);
        }
    }

    @Override
    public double[] getLowerBound() {
        double[] bound = new double[this.texts[0].coordinates.length];
        Arrays.fill(bound, Double.POSITIVE_INFINITY);
        for (Label text : this.texts) {
            double[] x = text.coordinates;
            for (int i = 0; i < x.length; ++i) {
                if (!(bound[i] > x[i])) continue;
                bound[i] = x[i];
            }
        }
        return bound;
    }

    @Override
    public double[] getUpperBound() {
        double[] bound = new double[this.texts[0].coordinates.length];
        Arrays.fill(bound, Double.NEGATIVE_INFINITY);
        for (Label text : this.texts) {
            double[] x = text.coordinates;
            for (int i = 0; i < x.length; ++i) {
                if (!(bound[i] < x[i])) continue;
                bound[i] = x[i];
            }
        }
        return bound;
    }

    public static TextPlot of(String[] texts, double[][] coordinates) {
        if (texts.length != coordinates.length) {
            throw new IllegalArgumentException("The number of texts and that of coordinates are not the same.");
        }
        int n = texts.length;
        Label[] labels = new Label[n];
        for (int i = 0; i < n; ++i) {
            labels[i] = Label.of(texts[i], coordinates[i]);
        }
        return new TextPlot(labels);
    }
}

