/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.swing;

import java.awt.Color;
import java.util.Optional;
import smile.plot.swing.Canvas;
import smile.plot.swing.Graphics;
import smile.plot.swing.Legend;
import smile.plot.swing.Line;
import smile.plot.swing.Plot;
import smile.projection.PCA;

public class ScreePlot
extends Plot {
    private static Legend[] legends = new Legend[]{new Legend("Variance", Color.RED), new Legend("Cumulative Variance", Color.BLUE)};
    private PCA pca;
    private double[] x;
    private String[] labels;
    private Line[] lines;

    public ScreePlot(PCA pca) {
        this.pca = pca;
        int n = pca.getVarianceProportion().length;
        this.labels = new String[n];
        this.x = new double[n];
        double[][] var = new double[n][2];
        double[][] cumVar = new double[n][2];
        for (int i = 0; i < n; ++i) {
            this.labels[i] = "PC" + (i + 1);
            this.x[i] = i + 1;
            var[i][0] = this.x[i];
            var[i][1] = pca.getVarianceProportion()[i];
            cumVar[i][0] = this.x[i];
            cumVar[i][1] = pca.getCumulativeVarianceProportion()[i];
        }
        this.lines = new Line[]{new Line(var, Line.Style.SOLID, '@', Color.RED), new Line(cumVar, Line.Style.SOLID, '@', Color.BLUE)};
    }

    @Override
    public void paint(Graphics g) {
        for (Line line : this.lines) {
            line.paint(g);
        }
    }

    @Override
    public Optional<Legend[]> legends() {
        return Optional.of(legends);
    }

    @Override
    public Canvas canvas() {
        Canvas canvas = new Canvas(this.getLowerBound(), this.getUpperBound(), false);
        canvas.setAxisLabels("Principal Component", "Proportion of Variance");
        canvas.getAxis(0).setTicks(this.labels, this.x);
        canvas.add(this);
        return canvas;
    }

    @Override
    public double[] getLowerBound() {
        double[] bound = new double[]{1.0, 0.0};
        return bound;
    }

    @Override
    public double[] getUpperBound() {
        int n = this.pca.getVarianceProportion().length;
        double[] bound = new double[]{n, 1.0};
        return bound;
    }
}

