/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.swing;

import smile.plot.swing.Canvas;
import smile.plot.swing.Projection;

class Projection3D
extends Projection {
    private double theta = 0.7853981633974483;
    private double phi = 0.39269908169872414;
    private double sinTheta = Math.sin(this.theta);
    private double cosTheta = Math.cos(this.theta);
    private double sinPhi = Math.sin(this.phi);
    private double cosPhi = Math.cos(this.phi);
    private double factor = 1.7;

    public Projection3D(Canvas canvas) {
        super(canvas);
    }

    private void precompute() {
        this.sinTheta = Math.sin(this.theta);
        this.cosTheta = Math.cos(this.theta);
        this.sinPhi = Math.sin(this.phi);
        this.cosPhi = Math.cos(this.phi);
    }

    public double[] project(double[] xyz) {
        double[] coord = new double[]{this.cosTheta * xyz[1] - this.sinTheta * xyz[0], this.cosPhi * xyz[2] - this.sinPhi * this.cosTheta * xyz[0] - this.sinPhi * this.sinTheta * xyz[1], this.cosPhi * this.sinTheta * xyz[1] + this.sinPhi * xyz[2] + this.cosPhi * this.cosTheta * xyz[0]};
        return coord;
    }

    public double z(double[] xyz) {
        return this.cosPhi * this.sinTheta * xyz[1] + this.sinPhi * xyz[2] + this.cosPhi * this.cosTheta * xyz[0];
    }

    @Override
    double[] baseCoordsScreenProjectionRatio(double[] xyz) {
        double[] sc = new double[]{0.5 + (this.cosTheta * ((xyz[1] - (this.canvas.base.upperBound[1] + this.canvas.base.lowerBound[1]) / 2.0) / (this.canvas.base.upperBound[1] - this.canvas.base.lowerBound[1])) - this.sinTheta * ((xyz[0] - (this.canvas.base.upperBound[0] + this.canvas.base.lowerBound[0]) / 2.0) / (this.canvas.base.upperBound[0] - this.canvas.base.lowerBound[0]))) / this.factor, 0.5 + (this.cosPhi * ((xyz[2] - (this.canvas.base.upperBound[2] + this.canvas.base.lowerBound[2]) / 2.0) / (this.canvas.base.upperBound[2] - this.canvas.base.lowerBound[2])) - this.sinPhi * this.cosTheta * ((xyz[0] - (this.canvas.base.upperBound[0] + this.canvas.base.lowerBound[0]) / 2.0) / (this.canvas.base.upperBound[0] - this.canvas.base.lowerBound[0])) - this.sinPhi * this.sinTheta * ((xyz[1] - (this.canvas.base.upperBound[1] + this.canvas.base.lowerBound[1]) / 2.0) / (this.canvas.base.upperBound[1] - this.canvas.base.lowerBound[1]))) / this.factor};
        return sc;
    }

    public void setDefaultView() {
        this.setView(0.7853981633974483, 0.39269908169872414);
    }

    public void setView(double theta, double phi) {
        this.theta = theta;
        this.phi = phi;
        this.precompute();
        this.reset();
    }

    public void rotate(double t, double p) {
        this.theta -= t / 100.0;
        this.phi += p / 100.0;
        this.precompute();
        this.reset();
    }
}

