/*
 * Decompiled with CFR 0.152.
 */
package smile.plot;

import java.awt.Color;
import java.util.Arrays;
import java.util.HashMap;
import smile.math.Math;
import smile.plot.Graphics;
import smile.plot.Plot;
import smile.plot.PlotCanvas;

public class ScatterPlot
extends Plot {
    private double[][] data;
    private int[] y;
    private char[] legends;
    private Color[] palette;
    private HashMap<Integer, Integer> classLookupTable;
    private char legend;
    private String[] labels;

    public ScatterPlot(double[][] data) {
        this(data, 'o');
    }

    public ScatterPlot(double[][] data, String[] labels) {
        if (data.length != labels.length) {
            throw new IllegalArgumentException("The number of points and that of labels are not same.");
        }
        this.data = data;
        this.labels = labels;
    }

    public ScatterPlot(double[][] data, char legend) {
        this.data = data;
        this.legend = legend;
    }

    public ScatterPlot(double[][] data, Color color) {
        this(data, 'o', color);
    }

    public ScatterPlot(double[][] data, char legend, Color color) {
        super(color);
        this.data = data;
        this.legend = legend;
    }

    public ScatterPlot(double[][] data, int[] y, char[] legends) {
        this(data, y, legends, (Color[])null);
    }

    public ScatterPlot(double[][] data, int[] y, char[] legends, Color color) {
        this(data, y, legends, (Color[])null);
        this.setColor(color);
    }

    public ScatterPlot(double[][] data, int[] y, Color[] palette) {
        this(data, y, null, palette);
    }

    public ScatterPlot(double[][] data, int[] y, char legend, Color[] palette) {
        this(data, y, null, palette);
        this.legend = legend;
    }

    public ScatterPlot(double[][] data, int[] y, char[] legends, Color[] palette) {
        if (data.length != y.length) {
            throw new IllegalArgumentException("Data and label size are different.");
        }
        int[] id = Math.unique((int[])y);
        Arrays.sort(id);
        this.classLookupTable = new HashMap(id.length);
        for (int i = 0; i < id.length; ++i) {
            this.classLookupTable.put(id[i], i);
        }
        int k = id.length;
        if (legends != null && k > legends.length) {
            throw new IllegalArgumentException("Too few legends.");
        }
        if (palette != null && k > palette.length) {
            throw new IllegalArgumentException("Too few colors.");
        }
        this.data = data;
        this.y = y;
        this.legends = legends;
        this.palette = palette;
    }

    @Override
    public void paint(Graphics g) {
        Color c = g.getColor();
        g.setColor(this.getColor());
        if (this.labels != null) {
            for (int i = 0; i < this.data.length; ++i) {
                g.drawText(this.labels[i], this.data[i]);
            }
        } else if (this.y == null) {
            for (int i = 0; i < this.data.length; ++i) {
                g.drawPoint(this.legend, this.data[i]);
            }
        } else {
            for (int i = 0; i < this.data.length; ++i) {
                if (this.palette != null) {
                    g.setColor(this.palette[this.classLookupTable.get(this.y[i])]);
                }
                if (this.legends != null) {
                    g.drawPoint(this.legends[this.classLookupTable.get(this.y[i])], this.data[i]);
                    continue;
                }
                g.drawPoint(this.legend, this.data[i]);
            }
        }
        g.setColor(c);
    }

    public ScatterPlot setLegend(char legend) {
        this.legend = legend;
        return this;
    }

    public char getLegend() {
        return this.legend;
    }

    public static PlotCanvas plot(double[] ... data) {
        return ScatterPlot.plot(null, data);
    }

    public static PlotCanvas plot(String id, double[] ... data) {
        if (data[0].length != 2 && data[0].length != 3) {
            throw new IllegalArgumentException("Invalid data dimension: " + data[0].length);
        }
        double[] lowerBound = Math.colMin((double[][])data);
        double[] upperBound = Math.colMax((double[][])data);
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound);
        ScatterPlot plot = new ScatterPlot(data);
        plot.setID(id);
        canvas.add(plot);
        return canvas;
    }

    public static PlotCanvas plot(double[][] data, String[] labels) {
        return ScatterPlot.plot(null, data, labels);
    }

    public static PlotCanvas plot(String id, double[][] data, String[] labels) {
        if (data[0].length != 2 && data[0].length != 3) {
            throw new IllegalArgumentException("Invalid data dimension: " + data[0].length);
        }
        if (data.length != labels.length) {
            throw new IllegalArgumentException("The number of points and that of labels are not same.");
        }
        double[] lowerBound = Math.colMin((double[][])data);
        double[] upperBound = Math.colMax((double[][])data);
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound);
        ScatterPlot plot = new ScatterPlot(data, labels);
        plot.setID(id);
        canvas.add(plot);
        return canvas;
    }

    public static PlotCanvas plot(double[][] data, Color color) {
        return ScatterPlot.plot(null, data, color);
    }

    public static PlotCanvas plot(String id, double[][] data, Color color) {
        if (data[0].length != 2 && data[0].length != 3) {
            throw new IllegalArgumentException("Invalid data dimension: " + data[0].length);
        }
        double[] lowerBound = Math.colMin((double[][])data);
        double[] upperBound = Math.colMax((double[][])data);
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound);
        ScatterPlot plot = new ScatterPlot(data);
        plot.setID(id);
        plot.setColor(color);
        canvas.add(plot);
        return canvas;
    }

    public static PlotCanvas plot(double[][] data, char legend) {
        return ScatterPlot.plot(null, data, legend);
    }

    public static PlotCanvas plot(String id, double[][] data, char legend) {
        if (data[0].length != 2 && data[0].length != 3) {
            throw new IllegalArgumentException("Invalid data dimension: " + data[0].length);
        }
        double[] lowerBound = Math.colMin((double[][])data);
        double[] upperBound = Math.colMax((double[][])data);
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound);
        ScatterPlot plot = new ScatterPlot(data, legend);
        plot.setID(id);
        canvas.add(plot);
        return canvas;
    }

    public static PlotCanvas plot(double[][] data, char legend, Color color) {
        return ScatterPlot.plot(null, data, legend, color);
    }

    public static PlotCanvas plot(String id, double[][] data, char legend, Color color) {
        if (data[0].length != 2 && data[0].length != 3) {
            throw new IllegalArgumentException("Invalid data dimension: " + data[0].length);
        }
        double[] lowerBound = Math.colMin((double[][])data);
        double[] upperBound = Math.colMax((double[][])data);
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound);
        ScatterPlot plot = new ScatterPlot(data, legend);
        plot.setID(id);
        plot.setColor(color);
        canvas.add(plot);
        return canvas;
    }

    public static PlotCanvas plot(double[][] data, int[] y, char legend, Color[] palette) {
        return ScatterPlot.plot(null, data, y, legend, palette);
    }

    public static PlotCanvas plot(String id, double[][] data, int[] y, char legend, Color[] palette) {
        if (data[0].length != 2 && data[0].length != 3) {
            throw new IllegalArgumentException("Invalid data dimension: " + data[0].length);
        }
        double[] lowerBound = Math.colMin((double[][])data);
        double[] upperBound = Math.colMax((double[][])data);
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound);
        ScatterPlot plot = new ScatterPlot(data, y, legend, palette);
        plot.setID(id);
        canvas.add(plot);
        return canvas;
    }

    public static PlotCanvas plot(double[][] data, int[] y, char[] legend, Color[] palette) {
        return ScatterPlot.plot(null, data, y, legend, palette);
    }

    public static PlotCanvas plot(String id, double[][] data, int[] y, char[] legend, Color[] palette) {
        if (data[0].length != 2 && data[0].length != 3) {
            throw new IllegalArgumentException("Invalid data dimension: " + data[0].length);
        }
        double[] lowerBound = Math.colMin((double[][])data);
        double[] upperBound = Math.colMax((double[][])data);
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound);
        ScatterPlot plot = new ScatterPlot(data, y, legend, palette);
        plot.setID(id);
        canvas.add(plot);
        return canvas;
    }
}

