/*
 * Decompiled with CFR 0.152.
 */
package smile.plot;

import java.awt.Color;
import java.util.Arrays;
import smile.math.Math;
import smile.plot.Graphics;
import smile.plot.Plot;
import smile.plot.PlotCanvas;
import smile.stat.distribution.DiscreteDistribution;
import smile.stat.distribution.Distribution;
import smile.stat.distribution.GaussianDistribution;

public class QQPlot
extends Plot {
    private double[][] data;

    public QQPlot(double[] x) {
        this.data = QQPlot.quantile(x, (Distribution)GaussianDistribution.getInstance());
    }

    public QQPlot(double[] x, Distribution d) {
        this.data = QQPlot.quantile(x, d);
    }

    public QQPlot(int[] x, DiscreteDistribution d) {
        this.data = QQPlot.quantile(x, d);
    }

    public QQPlot(double[] x, double[] y) {
        this.data = QQPlot.quantile(x, y);
    }

    public QQPlot(int[] x, int[] y) {
        this.data = QQPlot.quantile(x, y);
    }

    private static double[][] quantile(double[] x, double[] y) {
        Arrays.sort(x);
        Arrays.sort(y);
        int n = Math.min((int)x.length, (int)y.length);
        double[][] q = new double[n][2];
        for (int i = 0; i < n; ++i) {
            double p = (double)(i + 1) / ((double)n + 1.0);
            q[i][0] = x[(int)Math.round((double)(p * (double)x.length))];
            q[i][1] = y[(int)Math.round((double)(p * (double)y.length))];
        }
        return q;
    }

    private static double[][] quantile(int[] x, int[] y) {
        Arrays.sort(x);
        Arrays.sort(y);
        int n = Math.min((int)x.length, (int)y.length);
        double[][] q = new double[n][2];
        for (int i = 0; i < n; ++i) {
            double p = (double)(i + 1) / ((double)n + 1.0);
            q[i][0] = x[(int)Math.round((double)(p * (double)x.length))];
            q[i][1] = y[(int)Math.round((double)(p * (double)y.length))];
        }
        return q;
    }

    private static double[][] quantile(double[] x, Distribution d) {
        Arrays.sort(x);
        int n = x.length;
        double[][] q = new double[n][2];
        for (int i = 0; i < n; ++i) {
            double p = (double)(i + 1) / ((double)n + 1.0);
            q[i][0] = x[(int)Math.round((double)(p * (double)x.length))];
            q[i][1] = d.quantile(p);
        }
        return q;
    }

    private static double[][] quantile(int[] x, DiscreteDistribution d) {
        Arrays.sort(x);
        int n = x.length;
        double[][] q = new double[n][2];
        for (int i = 0; i < n; ++i) {
            double p = (double)(i + 1) / ((double)n + 1.0);
            q[i][0] = x[(int)Math.round((double)(p * (double)x.length))];
            q[i][1] = d.quantile(p);
        }
        return q;
    }

    @Override
    public void paint(Graphics g) {
        Color c = g.getColor();
        g.setColor(this.getColor());
        double[] lowerEnd = g.getLowerBound();
        lowerEnd[0] = Math.min((double)lowerEnd[0], (double)lowerEnd[1]);
        lowerEnd[1] = lowerEnd[0];
        double[] upperEnd = g.getUpperBound();
        upperEnd[0] = Math.max((double)upperEnd[0], (double)upperEnd[1]);
        upperEnd[1] = upperEnd[0];
        g.drawLine(lowerEnd, upperEnd);
        for (int i = 0; i < this.data.length; ++i) {
            g.drawPoint('o', this.data[i]);
        }
        g.setColor(c);
    }

    public static PlotCanvas plot(double[] x) {
        double[] lowerBound = new double[]{Math.min((double[])x), GaussianDistribution.getInstance().quantile(1.0 / ((double)x.length + 1.0))};
        double[] upperBound = new double[]{Math.max((double[])x), GaussianDistribution.getInstance().quantile((double)x.length / ((double)x.length + 1.0))};
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound);
        canvas.add(new QQPlot(x));
        return canvas;
    }

    public static PlotCanvas plot(double[] x, Distribution d) {
        double[] lowerBound = new double[]{Math.min((double[])x), d.quantile(1.0 / ((double)x.length + 1.0))};
        double[] upperBound = new double[]{Math.max((double[])x), d.quantile((double)x.length / ((double)x.length + 1.0))};
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound);
        canvas.add(new QQPlot(x, d));
        return canvas;
    }

    public static PlotCanvas plot(double[] x, double[] y) {
        double[] lowerBound = new double[]{Math.min((double[])x), Math.min((double[])y)};
        double[] upperBound = new double[]{Math.max((double[])x), Math.max((double[])y)};
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound);
        canvas.add(new QQPlot(x, y));
        return canvas;
    }

    public static PlotCanvas plot(int[] x, DiscreteDistribution d) {
        double[] lowerBound = new double[]{Math.min((int[])x), d.quantile(1.0 / ((double)x.length + 1.0))};
        double[] upperBound = new double[]{Math.max((int[])x), d.quantile((double)x.length / ((double)x.length + 1.0))};
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound);
        canvas.add(new QQPlot(x, d));
        return canvas;
    }

    public static PlotCanvas plot(int[] x, int[] y) {
        double[] lowerBound = new double[]{Math.min((int[])x), Math.min((int[])y)};
        double[] upperBound = new double[]{Math.max((int[])x), Math.max((int[])y)};
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound);
        canvas.add(new QQPlot(x, y));
        return canvas;
    }
}

